/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.api;

import de.ellpeck.actuallyadditions.api.booklet.IBookletChapter;
import de.ellpeck.actuallyadditions.api.booklet.IBookletEntry;
import de.ellpeck.actuallyadditions.api.booklet.IBookletPage;
import de.ellpeck.actuallyadditions.api.internal.IMethodHandler;
import de.ellpeck.actuallyadditions.api.laser.ILaserRelayConnectionHandler;
import de.ellpeck.actuallyadditions.api.lens.Lens;
import de.ellpeck.actuallyadditions.api.lens.LensConversion;
import de.ellpeck.actuallyadditions.api.recipe.BallOfFurReturn;
import de.ellpeck.actuallyadditions.api.recipe.CoffeeIngredient;
import de.ellpeck.actuallyadditions.api.recipe.CompostRecipe;
import de.ellpeck.actuallyadditions.api.recipe.CrusherRecipe;
import de.ellpeck.actuallyadditions.api.recipe.EmpowererRecipe;
import de.ellpeck.actuallyadditions.api.recipe.IColorLensChanger;
import de.ellpeck.actuallyadditions.api.recipe.LensConversionRecipe;
import de.ellpeck.actuallyadditions.api.recipe.TreasureChestLoot;
import de.ellpeck.actuallyadditions.api.recipe.WeightedOre;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public final class ActuallyAdditionsAPI {
    public static final String MOD_ID = "actuallyadditions";
    public static final String API_ID = "actuallyadditionsapi";
    public static final String API_VERSION = "29";
    public static final List<CrusherRecipe> CRUSHER_RECIPES = new ArrayList<CrusherRecipe>();
    public static final List<BallOfFurReturn> BALL_OF_FUR_RETURN_ITEMS = new ArrayList<BallOfFurReturn>();
    public static final List<TreasureChestLoot> TREASURE_CHEST_LOOT = new ArrayList<TreasureChestLoot>();
    public static final List<LensConversionRecipe> RECONSTRUCTOR_LENS_CONVERSION_RECIPES = new ArrayList<LensConversionRecipe>();
    public static final List<EmpowererRecipe> EMPOWERER_RECIPES = new ArrayList<EmpowererRecipe>();
    public static final Map<Item, IColorLensChanger> RECONSTRUCTOR_LENS_COLOR_CHANGERS = new HashMap<Item, IColorLensChanger>();
    public static final List<CoffeeIngredient> COFFEE_MACHINE_INGREDIENTS = new ArrayList<CoffeeIngredient>();
    public static final List<CompostRecipe> COMPOST_RECIPES = new ArrayList<CompostRecipe>();
    public static final Map<String, Integer> OIL_GENERATOR_RECIPES = new HashMap<String, Integer>();
    public static final List<IBookletEntry> BOOKLET_ENTRIES = new ArrayList<IBookletEntry>();
    public static final List<IBookletChapter> ALL_CHAPTERS = new ArrayList<IBookletChapter>();
    public static final List<IBookletPage> BOOKLET_PAGES_WITH_ITEM_OR_FLUID_DATA = new ArrayList<IBookletPage>();
    public static final List<WeightedOre> STONE_ORES = new ArrayList<WeightedOre>();
    public static final List<WeightedOre> NETHERRACK_ORES = new ArrayList<WeightedOre>();
    public static IMethodHandler methodHandler;
    public static ILaserRelayConnectionHandler connectionHandler;
    public static IBookletEntry entryGettingStarted;
    public static IBookletEntry entryReconstruction;
    public static IBookletEntry entryLaserRelays;
    public static IBookletEntry entryFunctionalNonRF;
    public static IBookletEntry entryFunctionalRF;
    public static IBookletEntry entryGeneratingRF;
    public static IBookletEntry entryItemsNonRF;
    public static IBookletEntry entryItemsRF;
    public static IBookletEntry entryMisc;
    public static IBookletEntry entryUpdatesAndInfos;
    public static IBookletEntry allAndSearch;
    public static LensConversion lensDefaultConversion;
    public static Lens lensDetonation;
    public static Lens lensDeath;
    public static Lens lensEvenMoarDeath;
    public static Lens lensColor;
    public static Lens lensDisruption;
    public static Lens lensDisenchanting;
    public static Lens lensMining;

    public static void addMiningLensStoneOre(String oreName, int weight) {
        STONE_ORES.add(new WeightedOre(oreName, weight));
    }

    public static void addMiningLensNetherOre(String oreName, int weight) {
        NETHERRACK_ORES.add(new WeightedOre(oreName, weight));
    }

    public static void addCrusherRecipe(ItemStack input, ItemStack outputOne, ItemStack outputTwo, int outputTwoChance) {
        CRUSHER_RECIPES.add(new CrusherRecipe(input, outputOne, outputTwo, outputTwoChance));
    }

    public static boolean addCrusherRecipes(List<ItemStack> inputs, List<ItemStack> outputOnes, int outputOneAmounts, List<ItemStack> outputTwos, int outputTwoAmounts, int outputTwoChance) {
        return methodHandler.addCrusherRecipes(inputs, outputOnes, outputOneAmounts, outputTwos, outputTwoAmounts, outputTwoChance);
    }

    public static void addOilGenRecipe(String fluidName, int genAmount) {
        OIL_GENERATOR_RECIPES.put(fluidName, genAmount);
    }

    public static void addCompostRecipe(ItemStack input, Block inputDisplay, ItemStack output, Block outputDisplay) {
        COMPOST_RECIPES.add(new CompostRecipe(input, inputDisplay, output, outputDisplay));
    }

    public static void addBallOfFurReturnItem(ItemStack stack, int chance) {
        BALL_OF_FUR_RETURN_ITEMS.add(new BallOfFurReturn(stack, chance));
    }

    public static void addTreasureChestLoot(ItemStack stack, int chance, int minAmount, int maxAmount) {
        TREASURE_CHEST_LOOT.add(new TreasureChestLoot(stack, chance, minAmount, maxAmount));
    }

    public static void addEmpowererRecipe(ItemStack input, ItemStack output, ItemStack modifier1, ItemStack modifier2, ItemStack modifier3, ItemStack modifier4, int energyPerStand, int time, float[] particleColor) {
        EMPOWERER_RECIPES.add(new EmpowererRecipe(input, output, modifier1, modifier2, modifier3, modifier4, energyPerStand, time, particleColor));
    }

    public static void addReconstructorLensConversionRecipe(ItemStack input, ItemStack output, int energyUse, LensConversion type) {
        RECONSTRUCTOR_LENS_CONVERSION_RECIPES.add(new LensConversionRecipe(input, output, energyUse, type));
    }

    public static void addReconstructorLensConversionRecipe(ItemStack input, ItemStack output, int energyUse) {
        ActuallyAdditionsAPI.addReconstructorLensConversionRecipe(input, output, energyUse, lensDefaultConversion);
    }

    public static void addReconstructorLensColorChangeItem(Item item, IColorLensChanger changer) {
        RECONSTRUCTOR_LENS_COLOR_CHANGERS.put(item, changer);
    }

    public static void addCoffeeMachineIngredient(CoffeeIngredient ingredient) {
        COFFEE_MACHINE_INGREDIENTS.add(ingredient);
    }

    public static void addBookletEntry(IBookletEntry entry) {
        BOOKLET_ENTRIES.add(entry);
    }
}

