/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.events;

import de.maxhenkel.gravestone.Config;
import de.maxhenkel.gravestone.DeathInfo;
import de.maxhenkel.gravestone.GraveProcessor;
import de.maxhenkel.gravestone.Log;
import de.maxhenkel.gravestone.ModItems;
import de.maxhenkel.gravestone.util.Tools;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class DeathEvents {
    private boolean livingGraves = Config.livingGraves;
    private boolean givePlayerNote = Config.giveDeathNotes;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerCloneLast(PlayerEvent.Clone event) {
        if (!this.givePlayerNote) {
            return;
        }
        if (event.isCanceled()) {
            return;
        }
        if (!event.isWasDeath()) {
            return;
        }
        if (Tools.keepInventory(event.getEntityPlayer())) {
            return;
        }
        for (ItemStack stack : event.getOriginal().field_71071_by.field_70462_a) {
            if (!DeathInfo.isDeathInfoItem(stack)) continue;
            event.getEntityPlayer().field_71071_by.func_70441_a(stack);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void playerDeath(LivingDropsEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (!(event.getEntity() instanceof EntityLivingBase)) {
            return;
        }
        if (!(event.getEntity() instanceof EntityPlayer) && !this.livingGraves) {
            return;
        }
        if (event.getEntity().func_130014_f_().field_72995_K) {
            return;
        }
        try {
            List drops = event.getDrops();
            EntityLivingBase entity = (EntityLivingBase)event.getEntity();
            GraveProcessor graveProcessor = new GraveProcessor(entity);
            if (graveProcessor.placeGraveStone(drops)) {
                event.setCanceled(true);
            } else if (entity instanceof EntityPlayerMP) {
                String modname = new TextComponentTranslation("message.name", new Object[0]).func_150254_d();
                String message = new TextComponentTranslation("message.create_grave_failed", new Object[0]).func_150254_d();
                EntityPlayerMP player = (EntityPlayerMP)entity;
                player.func_145747_a((ITextComponent)new TextComponentString("[" + modname + "] " + message));
            }
            if (this.givePlayerNote) {
                graveProcessor.givePlayerNote();
            }
        }
        catch (Exception e) {
            Log.w("Failed to process death of '" + event.getEntity().func_70005_c_() + "'");
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void playerDeath(LivingDeathEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (!(event.getEntity() instanceof EntityPlayer)) {
            return;
        }
        if (event.getEntity().func_130014_f_().field_72995_K) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntity();
        if (!Tools.keepInventory(player)) {
            return;
        }
        try {
            DeathEvents.givePlayerNote(player);
        }
        catch (Exception e) {
            Log.w("Failed to give player '" + player.getDisplayNameString() + "' death note");
        }
    }

    public static void givePlayerNote(EntityPlayer player) {
        DeathInfo info = new DeathInfo(player.func_180425_c(), player.field_71093_bK, new DeathInfo.ItemInfo[0], player.getDisplayNameString(), System.currentTimeMillis(), player.func_110124_au());
        ItemStack stack = new ItemStack((Item)ModItems.DEATH_INFO);
        info.addToItemStack(stack);
        player.field_71071_by.func_70441_a(stack);
    }
}

