/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone;

import de.maxhenkel.gravestone.ModItems;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;

public class DeathInfo {
    public static final String KEY_INFO = "info";
    public static final String KEY_POS_X = "pos_x";
    public static final String KEY_POS_Y = "pos_y";
    public static final String KEY_POS_Z = "pos_z";
    public static final String KEY_DIM = "dim";
    public static final String KEY_TIME = "time";
    public static final String KEY_ITEMS = "items";
    public static final String KEY_NAME = "name";
    public static final String KEY_UUID = "uuid";
    private BlockPos deathLocation;
    private int dimension;
    private ItemInfo[] items;
    private String name;
    private UUID uuid;
    private long time;

    public DeathInfo(BlockPos deathLocation, int dimension, ItemInfo[] items, String name, long time, UUID uuid) {
        this.deathLocation = deathLocation;
        this.dimension = dimension;
        this.items = items;
        this.name = name;
        this.time = time;
        this.uuid = uuid;
    }

    public BlockPos getDeathLocation() {
        return this.deathLocation;
    }

    public int getDimension() {
        return this.dimension;
    }

    public ItemInfo[] getItems() {
        return this.items;
    }

    public String getName() {
        return this.name;
    }

    public long getTime() {
        return this.time;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public NBTTagCompound toNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a(KEY_POS_X, this.deathLocation.func_177958_n());
        compound.func_74768_a(KEY_POS_Y, this.deathLocation.func_177956_o());
        compound.func_74768_a(KEY_POS_Z, this.deathLocation.func_177952_p());
        compound.func_74768_a(KEY_DIM, this.dimension);
        compound.func_74778_a(KEY_NAME, this.name);
        compound.func_74778_a(KEY_UUID, this.uuid.toString());
        compound.func_74772_a(KEY_TIME, this.time);
        NBTTagList itemList = new NBTTagList();
        for (ItemInfo s : this.items) {
            itemList.func_74742_a((NBTBase)s.toNBT());
        }
        compound.func_74782_a(KEY_ITEMS, (NBTBase)itemList);
        return compound;
    }

    public void addToItemStack(ItemStack stack) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a(KEY_INFO, (NBTBase)this.toNBT());
        stack.func_77982_d(compound);
    }

    public static DeathInfo fromNBT(NBTTagCompound compound) {
        try {
            int x = compound.func_74762_e(KEY_POS_X);
            int y = compound.func_74762_e(KEY_POS_Y);
            int z = compound.func_74762_e(KEY_POS_Z);
            BlockPos deathLocation = new BlockPos(x, y, z);
            int dimension = compound.func_74762_e(KEY_DIM);
            String name = compound.func_74779_i(KEY_NAME);
            String uuid = "";
            if (compound.func_74764_b(KEY_UUID)) {
                uuid = compound.func_74779_i(KEY_UUID);
            }
            long time = compound.func_74763_f(KEY_TIME);
            NBTTagList itemList = (NBTTagList)compound.func_74781_a(KEY_ITEMS);
            ItemInfo[] items = new ItemInfo[itemList.func_74745_c()];
            for (int i = 0; i < itemList.func_74745_c(); ++i) {
                NBTTagCompound s = itemList.func_150305_b(i);
                items[i] = ItemInfo.fromNBT(s);
            }
            return new DeathInfo(deathLocation, dimension, items, name, time, UUID.fromString(uuid));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static DeathInfo getDeathInfoFromPlayerHand(EntityPlayer player) {
        ItemStack stack = null;
        if (player.func_184614_ca() != null && DeathInfo.isDeathInfoItem(player.func_184614_ca().func_77973_b())) {
            stack = player.func_184614_ca();
        } else if (player.func_184592_cb() != null && DeathInfo.isDeathInfoItem(player.func_184592_cb().func_77973_b())) {
            stack = player.func_184592_cb();
        } else {
            return null;
        }
        if (!stack.func_77942_o()) {
            return null;
        }
        NBTTagCompound compound = stack.func_77978_p();
        if (!compound.func_74764_b(KEY_INFO)) {
            return null;
        }
        NBTTagCompound info = compound.func_74775_l(KEY_INFO);
        if (info == null) {
            return null;
        }
        return DeathInfo.fromNBT(info);
    }

    public static boolean isDeathInfoItem(Item item) {
        if (item == null) {
            return false;
        }
        return ((Object)((Object)ModItems.DEATH_INFO)).equals(item);
    }

    public static boolean isDeathInfoItem(ItemStack item) {
        if (item == null) {
            return false;
        }
        return DeathInfo.isDeathInfoItem(item.func_77973_b());
    }

    public static class ItemInfo {
        public static final String KEY_NAME = "name";
        public static final String KEY_STACK_SIZE = "stacksize";
        public static final String KEY_META = "meta";
        private String name;
        private int stackSize;
        private int meta;

        public ItemInfo(String name, int stackSize, int meta) {
            this.name = name;
            this.stackSize = stackSize;
            this.meta = meta;
        }

        public String getName() {
            return this.name;
        }

        public int getStackSize() {
            return this.stackSize;
        }

        public int getMeta() {
            return this.meta;
        }

        public NBTTagCompound toNBT() {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74778_a("name", this.name);
            compound.func_74768_a(KEY_STACK_SIZE, this.stackSize);
            compound.func_74768_a(KEY_META, this.meta);
            return compound;
        }

        public static ItemInfo fromNBT(NBTTagCompound compound) {
            int meta = 0;
            try {
                meta = compound.func_74762_e(KEY_META);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new ItemInfo(compound.func_74779_i("name"), compound.func_74762_e(KEY_STACK_SIZE), meta);
        }
    }
}

