/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.funkylocomotion.movers;

import com.rwtema.funkylocomotion.api.IMoveFactory;
import com.rwtema.funkylocomotion.blocks.BlockMoving;
import com.rwtema.funkylocomotion.blocks.TileMovingServer;
import com.rwtema.funkylocomotion.description.Describer;
import com.rwtema.funkylocomotion.factory.FactoryRegistry;
import com.rwtema.funkylocomotion.helper.BlockHelper;
import com.rwtema.funkylocomotion.helper.BlockStates;
import com.rwtema.funkylocomotion.movers.MovingTileRegistry;
import com.rwtema.funkylocomotion.network.FLNetwork;
import com.rwtema.funkylocomotion.network.MessageClearTile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ReportedException;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.NextTickListEntry;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import org.apache.commons.lang3.Validate;

public class MoveManager {
    public static final NBTTagCompound airBlockTag;
    public static final NBTTagCompound airDescTag;
    static final LinkedHashMap<String, Object> vars;
    private static final Object BLANK;

    public static void startMoving(World world, List<BlockPos> posList, EnumFacing dir, int maxTime) {
        ArrayList<BlockLink> links = new ArrayList<BlockLink>(posList.size());
        for (BlockPos blockPos : posList) {
            links.add(new BlockLink(blockPos, blockPos.func_177972_a(dir)));
        }
        MoveManager.startMoving(world, world, links, dir, maxTime);
    }

    public static synchronized void startMoving(World srcWorld, World dstWorld, List<BlockLink> links, @Nullable EnumFacing dir, int maxTime) {
        String section = "Start";
        MoveManager.clearVars();
        try {
            BlockPos dstPos;
            vars.put("srcWorld", srcWorld);
            vars.put("dstWorld", dstWorld);
            vars.put("links", links);
            vars.put("dir", dir);
            vars.put("maxTime", maxTime);
            if (dir != null && srcWorld != dstWorld) {
                throw new IllegalArgumentException("Trying to regular shift between worlds");
            }
            HashSet<BlockPos> srcBlocks = new HashSet<BlockPos>();
            HashSet<BlockPos> dstBlocks = new HashSet<BlockPos>();
            vars.put("srcBlocks", srcBlocks);
            vars.put("dstBlocks", dstBlocks);
            for (BlockLink link : links) {
                srcBlocks.add(link.srcPos);
                dstBlocks.add(link.dstPos);
            }
            HashSet<BlockPos> dstBlocksToBeDestroyed = new HashSet<BlockPos>();
            HashSet<BlockPos> srcBlocksToBecomeAir = new HashSet<BlockPos>();
            vars.put("dstBlocksToBeDestroyed", dstBlocksToBeDestroyed);
            vars.put("srcBlocksToBecomeAir", srcBlocksToBecomeAir);
            srcBlocksToBecomeAir.addAll(srcBlocks);
            dstBlocksToBeDestroyed.addAll(dstBlocks);
            if (srcWorld == dstWorld) {
                srcBlocksToBecomeAir.removeAll(dstBlocks);
                dstBlocksToBeDestroyed.removeAll(srcBlocks);
            }
            HashMap<BlockPos, Entry> dstTileEntries = new HashMap<BlockPos, Entry>();
            vars.put("dstTileEntries", dstTileEntries);
            section = "BreakBlockWithDrop";
            for (BlockPos pos : dstBlocksToBeDestroyed) {
                BlockHelper.breakBlockWithDrop(dstWorld, pos);
            }
            HashSet<Chunk> srcChunks = new HashSet<Chunk>();
            HashSet<TileEntity> inventories = new HashSet<TileEntity>();
            vars.put("srcChunks", srcChunks);
            vars.put("inventories", inventories);
            section = "Read Data";
            for (BlockLink link : links) {
                TileEntity tile;
                vars.put("Iterator", link);
                dstPos = link.dstPos;
                BlockPos srcPos = link.srcPos;
                Entry e = new Entry(dstPos);
                IBlockState state = srcWorld.func_180495_p(srcPos);
                e.block = state.func_177230_c();
                e.meta = e.block.func_176201_c(state);
                e.lightopacity = state.getLightOpacity((IBlockAccess)srcWorld, srcPos);
                e.lightlevel = state.getLightValue((IBlockAccess)srcWorld, srcPos);
                ArrayList axes = new ArrayList();
                state.func_185908_a(srcWorld, srcPos, TileEntity.INFINITE_EXTENT_AABB, axes, null);
                if (axes.size() > 0) {
                    e.bb = new ArrayList<AxisAlignedBB>();
                    for (AxisAlignedBB bb : axes) {
                        e.bb.add(new AxisAlignedBB(bb.field_72340_a - (double)srcPos.func_177958_n(), bb.field_72338_b - (double)srcPos.func_177956_o(), bb.field_72339_c - (double)srcPos.func_177952_p(), bb.field_72336_d - (double)srcPos.func_177958_n(), bb.field_72337_e - (double)srcPos.func_177956_o(), bb.field_72334_f - (double)srcPos.func_177952_p()));
                    }
                }
                NBTTagCompound descriptor = new NBTTagCompound();
                descriptor.func_74768_a("Block", Block.func_149682_b((Block)e.block));
                if (e.meta != 0) {
                    descriptor.func_74774_a("Meta", (byte)e.meta);
                }
                if ((tile = srcWorld.func_175625_s(srcPos)) != null) {
                    Describer.addDescriptionToTags(descriptor, tile);
                    if (tile instanceof IInventory) {
                        inventories.add(tile);
                    }
                }
                e.description = descriptor;
                srcChunks.add(srcWorld.func_175726_f(srcPos));
                dstTileEntries.put(dstPos, e);
            }
            vars.put("Iterator", BLANK);
            section = "LoadTicks";
            for (Chunk chunk : srcChunks) {
                vars.put("Iterator", chunk);
                List ticks = srcWorld.func_72920_a(chunk, false);
                if (ticks == null) continue;
                long k = srcWorld.func_82737_E();
                for (NextTickListEntry tick : ticks) {
                    vars.put("Iterator2", tick);
                    BlockPos pos = tick.field_180282_a;
                    if (chunk.func_177435_g(pos).func_177230_c() != tick.func_151351_a()) continue;
                    if (dir != null) {
                        pos = pos.func_177972_a(dir);
                    }
                    if (!dstTileEntries.containsKey(pos)) continue;
                    Entry e = (Entry)dstTileEntries.get(pos);
                    e.scheduledTickTime = (int)(tick.field_77180_e - k);
                    e.scheduledTickPriority = tick.field_82754_f;
                }
            }
            vars.put("Iterator", BLANK);
            vars.put("Iterator2", BLANK);
            section = "destroyBlock";
            for (BlockLink link : links) {
                vars.put("Iterator", link);
                IMoveFactory factory = FactoryRegistry.getFactory(srcWorld, link.srcPos);
                ((Entry)dstTileEntries.get((Object)link.dstPos)).blockTag = factory.destroyBlock(srcWorld, link.srcPos);
            }
            vars.put("Iterator", BLANK);
            vars.put("Iterator", BLANK);
            section = "clearTilesSilent";
            for (BlockLink link : links) {
                vars.put("Iterator", link);
                dstPos = link.dstPos;
                BlockPos srcPos = link.srcPos;
                BlockHelper.silentClear(dstWorld.func_175726_f(dstPos), dstPos);
                FLNetwork.sendToAllWatchingChunk(srcWorld, srcPos, new MessageClearTile(srcPos));
                dstWorld.func_175713_t(dstPos);
            }
            vars.put("Iterator", BLANK);
            section = "postUpdateBlock";
            for (BlockPos pos : srcBlocksToBecomeAir) {
                vars.put("Iterator", pos);
                BlockHelper.postUpdateBlock(dstWorld, pos);
            }
            vars.put("Iterator", BLANK);
            ArrayList<TileMovingServer> tiles = new ArrayList<TileMovingServer>();
            vars.put("tiles", tiles);
            section = "createTiles";
            for (Entry e : dstTileEntries.values()) {
                vars.put("Iterator", e);
                dstWorld.func_180501_a(e.pos, BlockMoving.instance.func_176223_P(), 1);
                TileMovingServer tile = (TileMovingServer)((Object)Validate.notNull((Object)dstWorld.func_175625_s(e.pos)));
                vars.put("Iterator2", (Object)tile);
                tile.block = e.blockTag;
                tile.desc = e.description;
                tile.dir = dir == null ? 6 : dir.ordinal();
                tile.maxTime = maxTime;
                tile.lightLevel = e.lightlevel;
                tile.lightOpacity = e.lightopacity;
                tile.scheduledTickTime = e.scheduledTickTime;
                tile.scheduledTickPriority = e.scheduledTickPriority;
                if (e.bb != null) {
                    tile.collisions = e.bb.toArray(new AxisAlignedBB[e.bb.size()]);
                }
                tile.isAir = false;
                tiles.add(tile);
            }
            vars.put("Iterator", BLANK);
            vars.put("Iterator2", BLANK);
            section = "createBlankTiles";
            for (BlockLink link : links) {
                vars.put("Iterator", BLANK);
                BlockPos srcPos = link.srcPos;
                if (srcWorld == dstWorld && dstTileEntries.containsKey(srcPos)) continue;
                srcWorld.func_180501_a(srcPos, BlockMoving.instance.func_176223_P(), 1);
                TileMovingServer tile = (TileMovingServer)((Object)Validate.notNull((Object)srcWorld.func_175625_s(srcPos)));
                vars.put("Iterator2", (Object)tile);
                if (dir != null) {
                    tile.block = airBlockTag.func_74737_b();
                    tile.desc = airDescTag.func_74737_b();
                    tile.dir = dir.ordinal();
                    tile.maxTime = maxTime;
                    tile.lightLevel = 0;
                    tile.lightOpacity = 0;
                    tile.isAir = true;
                } else {
                    FLNetwork.sendToAllWatchingChunk(srcWorld, srcPos, new MessageClearTile(srcPos));
                    Entry e = (Entry)dstTileEntries.get(link.dstPos);
                    tile.block = airBlockTag.func_74737_b();
                    tile.desc = e.description != null ? e.description.func_74737_b() : airDescTag.func_74737_b();
                    tile.dir = 7;
                    tile.maxTime = maxTime;
                    tile.lightLevel = e.lightlevel;
                    tile.lightOpacity = e.lightopacity;
                    if (e.bb != null) {
                        tile.collisions = e.bb.toArray(new AxisAlignedBB[e.bb.size()]);
                    }
                    tile.isAir = true;
                }
                tiles.add(tile);
            }
            vars.put("Iterator", BLANK);
            section = "networkUpdateBlocks";
            for (TileMovingServer tile : tiles) {
                vars.put("Iterator", (Object)tile);
                PlayerChunkMapEntry watcher = FLNetwork.getChunkWatcher(tile.func_145831_w(), tile.func_174877_v());
                if (watcher == null) continue;
                SPacketBlockChange pkt = new SPacketBlockChange(tile.func_145831_w(), tile.func_174877_v());
                watcher.func_187267_a((Packet)pkt);
            }
            vars.put("Iterator", BLANK);
            section = "networkUpdateTile";
            for (TileMovingServer tile : tiles) {
                vars.put("Iterator", (Object)tile);
                PlayerChunkMapEntry watcher = FLNetwork.getChunkWatcher(tile.func_145831_w(), tile.func_174877_v());
                if (watcher == null) continue;
                SPacketUpdateTileEntity packet = tile.func_189518_D_();
                vars.put("Iterator2", packet);
                if (packet == null) continue;
                watcher.func_187267_a((Packet)packet);
            }
            vars.put("Iterator", BLANK);
            vars.put("Iterator2", BLANK);
            section = "DoneIfWeCrashNowThenWhatTheHell";
            MoveManager.clearVars();
        }
        catch (Throwable err) {
            try {
                CrashReport crashReport = MoveManager.buildCrashReport(section, err);
                throw new ReportedException(crashReport);
            }
            catch (Throwable throwable) {
                MoveManager.clearVars();
                throw throwable;
            }
        }
    }

    private static CrashReport buildCrashReport(String section, Throwable err) {
        CrashReport crashReport = CrashReport.func_85055_a((Throwable)err, (String)"FunkyLocomotionMoveCrash");
        CrashReportCategory moveCode = crashReport.func_85058_a("MoveCode");
        moveCode.func_71507_a("Section", (Object)("\"" + section + "\""));
        for (Map.Entry<String, Object> e : vars.entrySet()) {
            Object value = e.getValue();
            if (value == BLANK) continue;
            moveCode.func_71507_a("var_" + e.getKey(), (Object)MoveManager.makeString(value, 0));
        }
        return crashReport;
    }

    private static void clearVars() {
        for (Map.Entry<String, Object> entry : vars.entrySet()) {
            entry.setValue(BLANK);
        }
    }

    public static void finishMoving() {
        MoveManager.clearVars();
        String section = "start";
        try {
            BlockPos pos;
            List<TileMovingServer> tiles = MovingTileRegistry.getTilesFinishedMoving();
            if (tiles.isEmpty()) {
                return;
            }
            HashSet<Chunk> chunks = new HashSet<Chunk>();
            vars.put("tiles", tiles);
            vars.put("chunks", tiles);
            section = "Clear Tiles";
            for (TileMovingServer tile : tiles) {
                vars.put("tile", (Object)tile);
                World worldObj = tile.func_145831_w();
                BlockPos pos2 = tile.func_174877_v();
                chunks.add(worldObj.func_175726_f(pos2));
                worldObj.func_180501_a(pos2, BlockStates.AIR, 0);
                worldObj.func_180501_a(pos2, BlockStates.STONE, 0);
            }
            vars.put("tile", BLANK);
            section = "Set Block/Tile";
            for (TileMovingServer tile : tiles) {
                pos = tile.func_174877_v();
                vars.put("tile", (Object)tile);
                if (tile.block == null) continue;
                BlockHelper.silentClear(tile.func_145831_w().func_175726_f(pos), pos);
                Block block = Block.func_149684_b((String)tile.block.func_74779_i("Block"));
                vars.put("block", block);
                if (block == null) {
                    block = Blocks.field_150350_a;
                }
                IMoveFactory factory = FactoryRegistry.getFactory(block);
                vars.put("factory", factory);
                factory.recreateBlock(tile.func_145831_w(), pos, tile.block);
            }
            vars.put("tile", BLANK);
            vars.put("block", BLANK);
            vars.put("factory", BLANK);
            section = "Update Blocks";
            for (TileMovingServer tile : tiles) {
                vars.put("tile", (Object)tile);
                pos = tile.func_174877_v();
                BlockHelper.postUpdateBlock(tile.func_145831_w(), pos);
                if (tile.scheduledTickTime == -1) continue;
                int time = tile.scheduledTickTime - 1;
                if (time <= 0) {
                    World world = tile.func_145831_w();
                    IBlockState state = world.func_180495_p(pos);
                    state.func_177230_c().func_180650_b(tile.func_145831_w(), tile.func_174877_v(), state, world.field_73012_v);
                    continue;
                }
                tile.func_145831_w().func_180497_b(tile.func_174877_v(), tile.func_145831_w().func_180495_p(pos).func_177230_c(), time, tile.scheduledTickPriority);
            }
            vars.put("tile", BLANK);
            section = "Send Update Packets";
            for (Chunk chunk : chunks) {
                vars.put("chunk", chunk);
                chunk.field_76643_l = true;
                FLNetwork.updateChunk(chunk);
            }
            vars.put("chunk", BLANK);
            section = "Redo Activation";
            for (TileMovingServer tile : tiles) {
                EntityPlayer player;
                vars.put("tile", (Object)tile);
                if (tile.activatingPlayer == null || (player = (EntityPlayer)tile.activatingPlayer.get()) == null) continue;
                IBlockState state = tile.func_145831_w().func_180495_p(tile.func_174877_v());
                Block b = state.func_177230_c();
                b.func_180639_a(tile.func_145831_w(), tile.func_174877_v(), state, player, tile.activatingHand, player.func_184586_b(tile.activatingHand), tile.activatingSide, tile.activatingHitX, tile.activatingHitY, tile.activatingHitZ);
            }
            vars.put("tile", BLANK);
            section = "Fin";
            MoveManager.clearVars();
        }
        catch (Throwable err) {
            try {
                CrashReport crashReport = MoveManager.buildCrashReport(section, err);
                throw new ReportedException(crashReport);
            }
            catch (Throwable throwable) {
                MoveManager.clearVars();
                throw throwable;
            }
        }
    }

    private static String makeString(Object o, int n) {
        if (o == null) {
            return "null";
        }
        if (o instanceof String) {
            return (String)o;
        }
        StringBuilder builder = new StringBuilder();
        MoveManager.tabs(n, builder);
        builder.append(o.getClass().getSimpleName());
        builder.append("{");
        if (o instanceof Block) {
            String nameForObject = "" + Block.field_149771_c.func_177774_c((Object)((Block)o));
            builder.append(nameForObject);
            builder.append(",");
            builder.append(o.toString());
        } else if (o instanceof TileEntity) {
            try {
                builder.append("tag=");
                NBTTagCompound tag = new NBTTagCompound();
                ((TileEntity)o).func_189515_b(tag);
                builder.append(tag.toString());
            }
            catch (Exception err) {
                builder.append("TE WriteToNBT Crash\n");
                builder.append(err.toString());
            }
        } else if (o instanceof Collection) {
            int i = 0;
            Iterator iterator = ((Iterable)o).iterator();
            builder.append('\n');
            MoveManager.tabs(n, builder);
            while (iterator.hasNext()) {
                builder.append("\t\t").append(i).append("=");
                ++i;
                builder.append(MoveManager.makeString(iterator.next(), n + 1));
                builder.append("\n");
                MoveManager.tabs(n, builder);
            }
        } else {
            builder.append(o.toString());
        }
        builder.append("}");
        return builder.toString();
    }

    private static void tabs(int n, StringBuilder builder) {
        for (int j = 0; j < n; ++j) {
            builder.append('\t');
        }
    }

    static {
        vars = new LinkedHashMap(10, 0.2f);
        BLANK = new Object();
        airBlockTag = new NBTTagCompound();
        airDescTag = new NBTTagCompound();
        if (Block.func_149682_b((Block)Blocks.field_150350_a) != 0) {
            airDescTag.func_74768_a("Block", Block.func_149682_b((Block)Blocks.field_150350_a));
        }
    }

    public static class BlockLink {
        BlockPos srcPos;
        BlockPos dstPos;

        public BlockLink(BlockPos srcPos, BlockPos dstPos) {
            this.srcPos = srcPos;
            this.dstPos = dstPos;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BlockLink blockLink = (BlockLink)o;
            return this.dstPos.equals((Object)blockLink.dstPos) && this.srcPos.equals((Object)blockLink.srcPos);
        }

        public int hashCode() {
            int result = this.srcPos.hashCode();
            result = 31 * result + this.dstPos.hashCode();
            return result;
        }

        public String toString() {
            return "BlockLink{" + this.srcPos.toString() + ", " + this.dstPos.toString() + '}';
        }
    }

    private static class Entry {
        final BlockPos pos;
        public int scheduledTickTime = -1;
        public int scheduledTickPriority;
        NBTTagCompound blockTag;
        NBTTagCompound description;
        Block block;
        int meta;
        List<AxisAlignedBB> bb = null;
        int lightlevel;
        int lightopacity;

        public Entry(BlockPos pos) {
            this.pos = pos;
        }

        public String toString() {
            return "Entry{scheduledTickTime=" + this.scheduledTickTime + ", scheduledTickPriority=" + this.scheduledTickPriority + ", blockTag=" + this.blockTag + ", description=" + this.description + ", pos=" + this.pos + ", block=" + MoveManager.makeString(this.block, 0) + ", meta=" + this.meta + ", bb=" + MoveManager.makeString(this.bb, 0) + ", lightlevel=" + this.lightlevel + ", lightopacity=" + this.lightopacity + '}';
        }
    }
}

