/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.funkylocomotion.fakes;

import com.mojang.authlib.GameProfile;
import com.rwtema.funkylocomotion.blocks.TileMovingClient;
import com.rwtema.funkylocomotion.helper.BlockStates;
import java.util.HashMap;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ChunkProviderClient;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.EnumPacketDirection;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class FakeWorldClient
extends WorldClient {
    private static final HashMap<World, FakeWorldClient> cache = new HashMap();
    private static GameProfile MINECRAFT = new GameProfile(UUID.fromString("41C82C87-7AfB-4024-BA57-13D2C99CAE77"), "[Minecraft]");
    final World world;
    final WorldClient worldClient;
    public double offset = 0.0;
    public int dir_id = -1;
    @Nullable
    public EnumFacing dir = null;
    public HashMap<BlockPos, IBlockState> blockstateOverides = new HashMap();
    public HashMap<BlockPos, TileEntity> tileOverides = new HashMap();
    public HashMap<BlockPos, TileMovingClient> tileClientOverides = new HashMap();

    private FakeWorldClient(World world) {
        super(new NetHandlerPlayClient(Minecraft.func_71410_x(), null, new NetworkManager(EnumPacketDirection.SERVERBOUND), MINECRAFT), new WorldSettings(world.func_72912_H()), world.field_73011_w.getDimension(), world.func_175659_aa(), world.field_72984_F);
        this.world = world;
        this.worldClient = world instanceof WorldClient ? (WorldClient)world : null;
    }

    public static boolean isValid(World world) {
        return world != null && world.field_73011_w != null && DimensionManager.isDimensionRegistered((int)world.field_73011_w.getDimension());
    }

    public static FakeWorldClient getFakeWorldWrapper(World world) {
        FakeWorldClient fakeWorldClient = cache.get(world);
        if (fakeWorldClient == null) {
            fakeWorldClient = world instanceof FakeWorldClient ? (FakeWorldClient)world : new FakeWorldClient(world);
            cache.put(world, fakeWorldClient);
        }
        return fakeWorldClient;
    }

    public static void register() {
        MinecraftForge.EVENT_BUS.register((Object)new FakeWorldManager());
    }

    public boolean func_175677_d(BlockPos pos, boolean _default) {
        IBlockState state = this.func_180495_p(pos);
        return state.func_177230_c().isNormalCube(state, (IBlockAccess)this, pos);
    }

    @Nonnull
    public Chunk func_72964_e(int x, int z) {
        return this.world.func_72964_e(x, z);
    }

    @Nonnull
    protected IChunkProvider func_72970_h() {
        return null;
    }

    public Entity func_73045_a(int id) {
        return this.world.func_73045_a(id);
    }

    public TileMovingClient getTile(BlockPos pos) {
        TileMovingClient overrideTile = this.tileClientOverides.get(pos);
        if (overrideTile != null) {
            return overrideTile;
        }
        TileEntity tile = this.world.func_175625_s(pos);
        return tile != null && tile.getClass() == TileMovingClient.class && ((TileMovingClient)tile).dir == this.dir_id ? (TileMovingClient)tile : null;
    }

    @Nonnull
    public IBlockState func_180495_p(BlockPos pos) {
        IBlockState state = this.blockstateOverides.get(pos);
        if (state != null) {
            return state;
        }
        TileMovingClient tile = this.getTile(pos);
        if (tile != null) {
            return tile.getState();
        }
        return BlockStates.AIR;
    }

    public Block getBlock(BlockPos pos) {
        return this.func_180495_p(pos).func_177230_c();
    }

    public TileEntity func_175625_s(BlockPos pos) {
        TileEntity tileEntity = this.tileOverides.get(pos);
        if (tileEntity != null) {
            return tileEntity;
        }
        TileMovingClient tileMovingClient = this.getTile(pos);
        return tileMovingClient == null ? null : tileMovingClient.tile;
    }

    public boolean func_180501_a(BlockPos pos, @Nonnull IBlockState newState, int flags) {
        return false;
    }

    public void func_175679_n(@Nonnull BlockPos pos) {
    }

    public int func_175699_k(BlockPos pos) {
        return super.func_175699_k(pos);
    }

    public int func_175642_b(@Nonnull EnumSkyBlock type, BlockPos pos) {
        return this.world.func_175642_b(type, pos);
    }

    public void func_184135_a(@Nonnull Packet<?> packetIn) {
    }

    @Nonnull
    public ChunkProviderClient func_72863_F() {
        return this.worldClient.func_72863_F();
    }

    public void func_73031_a(int x1, int y1, int z1, int x2, int y2, int z2) {
        this.worldClient.func_73031_a(x1, y1, z1, x2, y2, z2);
    }

    public void func_184153_a(int p_184153_1_, int p_184153_2_, int p_184153_3_, int p_184153_4_, @Nonnull Random random, boolean p_184153_6_, BlockPos.MutableBlockPos pos) {
        this.worldClient.func_184153_a(p_184153_1_, p_184153_2_, p_184153_3_, p_184153_4_, random, p_184153_6_, pos);
    }

    public void func_184148_a(@Nullable EntityPlayer player, double x, double y, double z, @Nonnull SoundEvent soundIn, @Nonnull SoundCategory category, float volume, float pitch) {
        this.worldClient.func_184148_a(player, x, y, z, soundIn, category, volume, pitch);
    }

    public void func_184156_a(BlockPos pos, @Nonnull SoundEvent soundIn, @Nonnull SoundCategory category, float volume, float pitch, boolean distanceDelay) {
        this.worldClient.func_184156_a(pos, soundIn, category, volume, pitch, distanceDelay);
    }

    public boolean func_175623_d(@Nonnull BlockPos pos) {
        IBlockState state = this.func_180495_p(pos);
        return state.func_185904_a() == Material.field_151579_a || state.func_177230_c().isAir(state, (IBlockAccess)this, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_72800_K() {
        return this.world.func_72800_K();
    }

    public boolean isSideSolid(BlockPos pos, @Nonnull EnumFacing side, boolean _default) {
        IBlockState state = this.func_180495_p(pos);
        return state.func_177230_c().isSideSolid(state, (IBlockAccess)this, pos, side);
    }

    public boolean func_72838_d(@Nonnull Entity entity) {
        return false;
    }

    public void func_175682_a(EnumParticleTypes particleType, boolean ignoreRange, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
        this.world.func_175682_a(particleType, ignoreRange, x + this.getXOffset(), y + this.getYOffset(), z + this.getZOffset(), xSpeed, ySpeed, zSpeed, parameters);
    }

    public void func_175688_a(EnumParticleTypes particleType, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
        this.world.func_175688_a(particleType, xCoord + this.getXOffset(), yCoord + this.getYOffset(), zCoord + this.getZOffset(), xSpeed, ySpeed, zSpeed, parameters);
    }

    private double getZOffset() {
        if (this.dir == null) {
            return 0.0;
        }
        return this.offset * (double)this.dir.func_82599_e();
    }

    private double getYOffset() {
        if (this.dir == null) {
            return 0.0;
        }
        return this.offset * (double)this.dir.func_96559_d();
    }

    private double getXOffset() {
        if (this.dir == null) {
            return 0.0;
        }
        return this.offset * (double)this.dir.func_82601_c();
    }

    public void func_72835_b() {
    }

    @Nonnull
    public CrashReportCategory func_72914_a(CrashReport crash) {
        CrashReportCategory crashReportCategory = this.world.func_72914_a(crash);
        crashReportCategory.func_71507_a("Fake World", (Object)"This world is a fake wrapper used by Funky Locomotion");
        return crashReportCategory;
    }

    public void func_73029_E(int posX, int posY, int posZ) {
        if (this.worldClient != null) {
            this.worldClient.func_73029_E(posX, posY, posZ);
        }
    }

    public void func_92088_a(double x, double y, double z, double vx, double vy, double vz, NBTTagCompound tag) {
        if (this.worldClient != null) {
            this.worldClient.func_92088_a(x, y, z, vx, vy, vz, tag);
        }
    }

    public void func_72900_e(Entity entity) {
    }

    public void func_73027_a(int id, Entity entity) {
    }

    @Nonnull
    public Entity func_73028_b(int entity) {
        return null;
    }

    public void func_184134_a(double x, double y, double z, SoundEvent soundIn, @Nonnull SoundCategory category, float volume, float pitch, boolean distanceDelay) {
        if (this.worldClient != null) {
            this.worldClient.func_184134_a(x, y, z, soundIn, category, volume, pitch, distanceDelay);
        }
    }

    public void func_73022_a() {
    }

    public void func_73025_a(int x, int z, boolean load) {
    }

    public void func_72882_A() {
        this.world.func_72882_A();
    }

    @SideOnly(value=Side.CLIENT)
    public static class FakeWorldManager {
        @SubscribeEvent
        public void onDimensionUnload(WorldEvent.Unload event) {
            cache.remove(event.getWorld());
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            if (server != null && !server.func_71278_l()) {
                cache.clear();
            }
        }
    }
}

