/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.funkylocomotion.blocks;

import com.rwtema.funkylocomotion.FunkyLocomotion;
import com.rwtema.funkylocomotion.api.ISlipperyBlock;
import com.rwtema.funkylocomotion.blocks.BlockFLMultiState;
import com.rwtema.funkylocomotion.blocks.TilePusher;
import com.rwtema.funkylocomotion.helper.ItemHelper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class BlockPusher
extends BlockFLMultiState
implements ISlipperyBlock {
    public static final PropertyEnum<PushPullType> PUSH_PULL_TYPE = PropertyEnum.func_177709_a((String)"push_pull", PushPullType.class);

    public BlockPusher() {
        super(Material.field_151576_e);
        this.func_149647_a(FunkyLocomotion.creativeTabFrames);
        this.func_149711_c(1.0f);
    }

    @Nonnull
    public IBlockState getStateForPlacement(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, int meta, @Nonnull EntityLivingBase placer, ItemStack stack) {
        return super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, stack).func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)EnumFacing.UP);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (worldIn.field_72995_K) {
            return;
        }
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TilePusher && placer instanceof EntityPlayer) {
            ((TilePusher)tileEntity).profile = ((EntityPlayer)placer).func_146103_bH();
        }
    }

    public void func_149666_a(@Nonnull Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        list.add(new ItemStack(itemIn, 1, 0));
        list.add(new ItemStack(itemIn, 1, 1));
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            ItemStack item = playerIn.func_184586_b(hand);
            if (!ItemHelper.isWrench(item)) {
                return false;
            }
            IBlockState blockState = worldIn.func_180495_p(pos);
            EnumFacing face = (EnumFacing)blockState.func_177229_b((IProperty)BlockDirectional.field_176387_N);
            if (side == face) {
                side = face.func_176734_d();
            }
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)side), 3);
        }
        return true;
    }

    @Override
    public boolean canStickTo(World world, BlockPos pos, EnumFacing dir) {
        return dir != null && world.func_180495_p(pos).func_177229_b((IProperty)BlockDirectional.field_176387_N) != dir;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn) {
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof TilePusher)) {
            return;
        }
        TilePusher tilePush = (TilePusher)tile;
        if (!(world instanceof WorldServer)) {
            return;
        }
        boolean bl = tilePush.powered = world.func_175687_A(pos) > 0;
        if (tilePush.powered) {
            tilePush.startCooldown();
        }
    }

    public boolean shouldCheckWeakPower(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TilePusher();
    }

    @Override
    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockDirectional.field_176387_N, PUSH_PULL_TYPE});
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)BlockDirectional.field_176387_N)).ordinal() + ((PushPullType)((Object)state.func_177229_b(BlockPusher.PUSH_PULL_TYPE))).metaMask;
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176223_P();
        state = state.func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)EnumFacing.values()[meta % 6]);
        state = state.func_177226_a(PUSH_PULL_TYPE, (Comparable)((Object)(meta < 6 ? PushPullType.PUSHER : PushPullType.PULLER)));
        return state;
    }

    static enum PushPullType implements IStringSerializable
    {
        PUSHER(0),
        PULLER(6);

        public final int metaMask;

        private PushPullType(int metaMask) {
            this.metaMask = metaMask;
        }

        public String func_176610_l() {
            return this.toString().toLowerCase();
        }
    }
}

