/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.funkylocomotion.blocks;

import com.rwtema.funkylocomotion.blocks.TileMovingBase;
import com.rwtema.funkylocomotion.blocks.TileMovingClient;
import com.rwtema.funkylocomotion.blocks.TileMovingServer;
import com.rwtema.funkylocomotion.fakes.FakeWorldClient;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockMoving
extends Block {
    public static BlockMoving instance;
    private final AxisAlignedBB ZERO_BOUNDS = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);

    public BlockMoving() {
        super(Material.field_151576_e);
        this.func_149722_s();
        this.setRegistryName("funkylocomotion:moving");
        instance = this;
    }

    public static boolean _Immoveable() {
        return true;
    }

    public void func_185477_a(IBlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull AxisAlignedBB entityBox, @Nonnull List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (!(tile instanceof TileMovingBase)) {
            return;
        }
        for (AxisAlignedBB bb : ((TileMovingBase)tile).getTransformedColisions()) {
            if (!entityBox.func_72326_a(bb)) continue;
            collidingBoxes.add(bb);
        }
        EnumFacing d = ((TileMovingBase)tile).getDir();
        if (d != null) {
            TileEntity tile2 = worldIn.func_175625_s(pos.func_177972_a(d));
            if (!(tile2 instanceof TileMovingBase)) {
                return;
            }
            for (AxisAlignedBB bb : ((TileMovingBase)tile2).getTransformedColisions()) {
                if (!entityBox.func_72326_a(bb)) continue;
                collidingBoxes.add(bb);
            }
        }
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, @Nonnull World worldIn, @Nonnull BlockPos pos) {
        return this.getBounds((IBlockAccess)worldIn, pos, false, false);
    }

    private AxisAlignedBB getBounds(@Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos, boolean renderOffset, boolean shrink) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileMovingBase) {
            TileMovingBase movingBase = (TileMovingBase)tile;
            return movingBase.getCombinedCollisions(renderOffset, shrink);
        }
        return field_185505_j;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        if (world.field_72995_K || FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            return new TileMovingClient();
        }
        return new TileMovingServer();
    }

    public boolean func_176214_u() {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, EntityPlayer player) {
        return null;
    }

    @Nonnull
    public AxisAlignedBB func_180640_a(IBlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos) {
        AxisAlignedBB bounds = this.getBounds((IBlockAccess)worldIn, pos, true, true);
        if (bounds == null) {
            return this.ZERO_BOUNDS;
        }
        return bounds.func_186670_a(pos);
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        AxisAlignedBB bounds = this.getBounds(source, pos, false, true);
        if (bounds == null) {
            return new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
        return bounds;
    }

    public int getLightValue(@Nonnull IBlockState state, IBlockAccess world, @Nonnull BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof TileMovingBase ? ((TileMovingBase)tile).lightLevel : super.getLightValue(state, world, pos);
    }

    public boolean func_176212_b(IBlockAccess worldIn, @Nonnull BlockPos pos, EnumFacing side) {
        return false;
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof TileMovingBase ? ((TileMovingBase)tile).lightOpacity : super.getLightOpacity(state, world, pos);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileMovingServer) {
            ((TileMovingServer)tile).cacheActivate(playerIn, side, hand, hitX, hitY, hitZ);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (!FakeWorldClient.isValid(worldIn)) {
            return;
        }
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileMovingClient) {
            TileMovingClient mover = (TileMovingClient)tile;
            FakeWorldClient fakeWorld = FakeWorldClient.getFakeWorldWrapper(worldIn);
            fakeWorld.offset = mover.offset(true);
            fakeWorld.dir_id = mover.dir;
            fakeWorld.dir = mover.getDir();
            IBlockState state = mover.block.func_176203_a(mover.meta);
            mover.block.func_180655_c(state, (World)fakeWorld, pos, rand);
            fakeWorld.offset = 0.0;
            fakeWorld.dir_id = -1;
        }
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }
}

