/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.funkylocomotion;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.rwtema.funkylocomotion.FunkyLocomotion;
import com.rwtema.funkylocomotion.Proxy;
import com.rwtema.funkylocomotion.blocks.BlockStickyFrame;
import com.rwtema.funkylocomotion.blocks.TileFrameProjector;
import com.rwtema.funkylocomotion.blocks.TileMovingClient;
import com.rwtema.funkylocomotion.eventhandler.ClientTimer;
import com.rwtema.funkylocomotion.fakes.FakeWorldClient;
import com.rwtema.funkylocomotion.rendering.ChunkRerenderer;
import com.rwtema.funkylocomotion.rendering.TESRMoving;
import com.rwtema.funkylocomotion.rendering.TESRProjector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.DefaultStateMapper;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.item.Item;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketPlayerTryUseItemOnBlock;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.Validate;

@SideOnly(value=Side.CLIENT)
public class ProxyClient
extends Proxy {
    @Override
    public void registerRendering() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileMovingClient.class, (TileEntitySpecialRenderer)TESRMoving.INSTANCE);
        ClientRegistry.bindTileEntitySpecialRenderer(TileFrameProjector.class, (TileEntitySpecialRenderer)TESRProjector.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)new ClientTimer());
        MinecraftForge.EVENT_BUS.register((Object)new ChunkRerenderer());
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a(resourceManager -> FunkyLocomotion.slider.init());
        FakeWorldClient.register();
        ModelLoader.setCustomStateMapper((Block)FunkyLocomotion.moving, blockIn -> ImmutableMap.of());
        for (final BlockStickyFrame frame : FunkyLocomotion.frame) {
            ModelLoader.setCustomStateMapper((Block)frame, (IStateMapper)new IStateMapper(){
                Map<IBlockState, ModelResourceLocation> mapStateModelLocations = Maps.newLinkedHashMap();
                DefaultStateMapper mapper = new DefaultStateMapper();

                @Nonnull
                public Map<IBlockState, ModelResourceLocation> func_178130_a(@Nonnull Block blockIn) {
                    for (int i = 0; i < 16; ++i) {
                        IBlockState state = frame.func_176203_a(i);
                        LinkedHashMap<PropertyBool, Comparable> values = new LinkedHashMap<PropertyBool, Comparable>();
                        ArrayList list = Lists.newArrayList((Object[])EnumFacing.values());
                        Collections.sort(list, (o1, o2) -> o1.func_176742_j().compareTo(o2.func_176742_j()));
                        for (EnumFacing facing : list) {
                            values.put(BlockStickyFrame.DIR_OPEN[facing.ordinal()], state.func_177229_b((IProperty)BlockStickyFrame.DIR_OPEN[facing.ordinal()]));
                        }
                        Validate.isTrue((boolean)frame.func_176194_O().func_177619_a().contains((Object)state));
                        this.mapStateModelLocations.put(state, new ModelResourceLocation("funkylocomotion:frame", this.mapper.func_178131_a(values)));
                    }
                    return this.mapStateModelLocations;
                }
            });
            for (int i = 0; i < 16; ++i) {
                ModelLoader.setCustomModelResourceLocation((Item)((Item)Validate.notNull((Object)Item.func_150898_a((Block)frame))), (int)i, (ModelResourceLocation)new ModelResourceLocation("funkylocomotion:frame", "inventory"));
            }
        }
        this.registerBlockItemModel(FunkyLocomotion.booster);
        this.registerBlockItemModel(FunkyLocomotion.slider);
        this.registerBlockItemModel(FunkyLocomotion.teleporter);
        this.registerBlockItemModel(FunkyLocomotion.frameProjector);
        ModelLoader.setCustomModelResourceLocation((Item)((Item)Validate.notNull((Object)Item.func_150898_a((Block)FunkyLocomotion.pusher))), (int)0, (ModelResourceLocation)new ModelResourceLocation("funkylocomotion:pusher", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)((Item)Validate.notNull((Object)Item.func_150898_a((Block)FunkyLocomotion.pusher))), (int)1, (ModelResourceLocation)new ModelResourceLocation("funkylocomotion:puller", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)FunkyLocomotion.wrench, (int)0, (ModelResourceLocation)new ModelResourceLocation("funkylocomotion:wrench", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)FunkyLocomotion.wrench, (int)1, (ModelResourceLocation)new ModelResourceLocation("funkylocomotion:wrench_eye", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)FunkyLocomotion.wrench, (int)2, (ModelResourceLocation)new ModelResourceLocation("funkylocomotion:wrench_hammer", "inventory"));
    }

    private void registerBlockItemModel(Block block) {
        Item item = (Item)Validate.notNull((Object)Item.func_150898_a((Block)block));
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
    }

    @Override
    public World getClientWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    @Override
    public void sendUsePacket(BlockPos pos, EnumFacing face, EnumHand hand, float hitX, float hitY, float hitZ) {
        NetHandlerPlayClient connection = Minecraft.func_71410_x().func_147114_u();
        if (connection != null) {
            connection.func_147297_a((Packet)new CPacketPlayerTryUseItemOnBlock(pos, face, hand, hitX, hitY, hitZ));
        }
    }
}

