/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.creeperhost.siv;

import java.io.IOException;
import java.util.Map;
import net.creeperhost.creeperhost.siv.EnumSIPValues;
import net.creeperhost.creeperhost.siv.ExtendedServerData;
import net.creeperhost.creeperhost.siv.Query;
import net.creeperhost.creeperhost.siv.SipEndPoint;

public class QueryGetter {
    private ExtendedServerData extendedServerData;
    private SipEndPoint sipEndPoint;

    public QueryGetter(String host, int port) {
        Query query = new Query(host, port);
        try {
            query.receivePort();
        }
        catch (Throwable e) {
            return;
        }
        int tcpPort = query.getTcpPort();
        this.sipEndPoint = new SipEndPoint(host, tcpPort);
        this.extendedServerData = new ExtendedServerData();
        this.extendedServerData.setHasData(false);
    }

    public void run() {
        try {
            if (this.extendedServerData == null || this.extendedServerData.isRequesting()) {
                return;
            }
            this.extendedServerData.setRequesting(true);
            this.sipEndPoint.requestExtendedInfo(EnumSIPValues.TPS, EnumSIPValues.DIMENSIONS, EnumSIPValues.ENTITIES);
            this.extendedServerData.setHasData(true);
            this.extendedServerData.setTPSList((Map)this.sipEndPoint.getExtendedObject(EnumSIPValues.TPS, this.extendedServerData.getTpsList().getClass()));
            this.extendedServerData.setDimensions((Map)this.sipEndPoint.getExtendedObject(EnumSIPValues.DIMENSIONS, this.extendedServerData.getDimensions().getClass()));
            this.extendedServerData.setEntities((Map)this.sipEndPoint.getExtendedObject(EnumSIPValues.ENTITIES, this.extendedServerData.getEntities().getClass()));
            this.extendedServerData.setRequesting(false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ExtendedServerData getExtendedServerData() {
        return this.extendedServerData;
    }
}

