/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.creeperhost;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Random;
import net.creeperhost.creeperhost.EventHandler;
import net.creeperhost.creeperhost.api.CreeperHostAPI;
import net.creeperhost.creeperhost.api.ICreeperHostMod;
import net.creeperhost.creeperhost.api.IServerHost;
import net.creeperhost.creeperhost.common.Config;
import net.creeperhost.creeperhost.paul.Callbacks;
import net.creeperhost.creeperhost.paul.CreeperHostServerHost;
import net.creeperhost.creeperhost.siv.QueryGetter;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="creeperhost", name="CreeperHost", version="unspecified", clientSideOnly=true, acceptableRemoteVersions="*", acceptedMinecraftVersions="1.9.4,1.10.2,1.11.2", guiFactory="net.creeperhost.creeperhost.gui.config.GuiCreeperConfigFactory")
public class CreeperHost
implements ICreeperHostMod {
    public static final String MOD_ID = "creeperhost";
    public static final String NAME = "CreeperHost";
    public static final String VERSION = "unspecified";
    public static final Logger logger = LogManager.getLogger((String)"creeperhost");
    @Mod.Instance
    public static CreeperHost instance;
    public ArrayList<IServerHost> implementations = new ArrayList();
    public IServerHost currentImplementation;
    public File configFile;
    private QueryGetter queryGetter;
    private String lastCurse = "";
    private Random randomGenerator;
    private CreeperHostServerHost implement;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        if (event.getSide() == Side.SERVER) {
            logger.info("Client side only mod - not doing anything on the server!");
            return;
        }
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
        this.configFile = event.getSuggestedConfigurationFile();
        InputStream configStream = null;
        try {
            String configString;
            if (this.configFile.exists()) {
                configStream = new FileInputStream(this.configFile);
                configString = IOUtils.toString((InputStream)configStream);
            } else {
                configString = "{}";
            }
            Config.loadConfig(configString);
        }
        catch (Throwable t) {
            logger.error("Unable to read config", t);
            throw new RuntimeException("Fatal error, unable to read config");
        }
        finally {
            try {
                if (configStream != null) {
                    configStream.close();
                }
            }
            catch (Throwable configString) {}
        }
        this.saveConfig();
    }

    public void saveConfig() {
        FileOutputStream configOut = null;
        try {
            configOut = new FileOutputStream(this.configFile);
            IOUtils.write((String)Config.saveConfig(), (OutputStream)configOut);
            configOut.close();
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                if (configOut != null) {
                    configOut.close();
                }
            }
            catch (Throwable throwable) {}
        }
        if (Config.getInstance().isCreeperhostEnabled() && this.implement == null) {
            Config.getInstance().setVersion(Callbacks.getVersionFromCurse(Config.getInstance().curseProjectID));
            CreeperHost.instance.implementations.remove(this.implement);
            this.implement = new CreeperHostServerHost();
            CreeperHostAPI.registerImplementation(this.implement);
        }
        if (Config.getInstance().curseProjectID != this.lastCurse && Config.getInstance().isCreeperhostEnabled()) {
            Config.getInstance().setVersion(Callbacks.getVersionFromCurse(Config.getInstance().curseProjectID));
        }
        if (!Config.getInstance().isCreeperhostEnabled()) {
            CreeperHost.instance.implementations.remove(this.implement);
            this.implement = null;
        }
        this.lastCurse = Config.getInstance().curseProjectID;
    }

    public void setRandomImplementation() {
        if (this.randomGenerator == null) {
            this.randomGenerator = new Random();
        }
        if (this.implementations.size() == 0) {
            this.currentImplementation = null;
            return;
        }
        int random = this.randomGenerator.nextInt(this.implementations.size());
        this.currentImplementation = this.implementations.get(random);
    }

    public IServerHost getImplementation() {
        return this.currentImplementation;
    }

    @Override
    public void registerImplementation(IServerHost serverHost) {
        this.implementations.add(serverHost);
    }

    public void makeQueryGetter() {
        try {
            if (FMLClientHandler.instance().getClientToServerNetworkManager() != null) {
                SocketAddress socketAddress = FMLClientHandler.instance().getClientToServerNetworkManager().func_74430_c();
                String host = "127.0.0.1";
                int port = 25565;
                if (socketAddress instanceof InetSocketAddress) {
                    InetSocketAddress add = (InetSocketAddress)socketAddress;
                    host = add.getHostName();
                    port = add.getPort();
                }
                this.queryGetter = new QueryGetter(host, port);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public QueryGetter getQueryGetter() {
        if (this.queryGetter == null) {
            this.makeQueryGetter();
        }
        return this.queryGetter;
    }
}

