/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.tileentity;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.common.IInventoryGui;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.smeltery.client.GuiSearedFurnace;
import slimeknights.tconstruct.smeltery.inventory.ContainerSearedFurnace;
import slimeknights.tconstruct.smeltery.multiblock.MultiblockSearedFurnace;
import slimeknights.tconstruct.smeltery.tileentity.TileHeatingStructureFuelTank;

public class TileSearedFurnace
extends TileHeatingStructureFuelTank<MultiblockSearedFurnace>
implements ITickable,
IInventoryGui {
    public static final Logger log = Util.getLogger("Furnace");
    protected int tick;

    public TileSearedFurnace() {
        super("gui.searedfurnace.name", 0, 16);
        this.setMultiblock(new MultiblockSearedFurnace(this));
    }

    public void func_73660_a() {
        if (this.isClientWorld()) {
            return;
        }
        if (!this.isActive()) {
            if (this.tick == 0) {
                this.checkMultiblockStructure();
            }
        } else {
            if (this.tick % 4 == 0) {
                this.heatItems();
            }
            if (this.tick == 0) {
                this.interactWithEntitiesInside();
            }
            if (this.needsFuel) {
                this.consumeFuel();
            }
        }
        this.tick = (this.tick + 1) % 20;
    }

    @Override
    protected void updateHeatRequired(int index) {
        ItemStack result;
        ItemStack stack = this.func_70301_a(index);
        if (stack != null && (result = FurnaceRecipes.func_77602_a().func_151395_a(stack)) != null) {
            int newSize = stack.field_77994_a * result.field_77994_a;
            if (newSize <= stack.func_77976_d() && newSize <= this.func_70297_j_()) {
                this.setHeatRequiredForSlot(index, this.getHeatForStack(stack, result));
            } else {
                this.itemTemperatures[index] = -1;
            }
            if (!this.hasFuel()) {
                this.consumeFuel();
            }
            return;
        }
        this.setHeatRequiredForSlot(index, 0);
    }

    private int getHeatForStack(@Nonnull ItemStack input, @Nonnull ItemStack result) {
        int base = 200;
        float temp = (float)(base * input.field_77994_a) / 4.0f;
        if (result.func_77973_b() instanceof ItemFood) {
            temp = (float)((double)temp * 0.8);
        }
        return (int)temp;
    }

    @Override
    protected boolean onItemFinishedHeating(ItemStack stack, int slot) {
        ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(stack);
        if (result == null) {
            return false;
        }
        result = result.func_77946_l();
        result.field_77994_a *= stack.field_77994_a;
        this.func_70299_a(slot, result);
        this.itemTemperatures[slot] = 1;
        this.itemTempRequired[slot] = 0;
        return false;
    }

    @Override
    protected int getUpdatedInventorySize(int width, int height, int depth) {
        return 9 + 3 * width * height * depth;
    }

    protected void interactWithEntitiesInside() {
        AxisAlignedBB bb = this.info.getBoundingBox().func_186664_h(1.0).func_72317_d(0.0, 0.5, 0.0).func_72314_b(0.0, 0.5, 0.0);
        List entities = this.func_145831_w().func_72872_a(EntityLivingBase.class, bb);
        for (EntityLivingBase entity : entities) {
            if (!(entity instanceof EntityMob) || !entity.func_70089_S()) continue;
            entity.func_70106_y();
        }
    }

    public Container createContainer(InventoryPlayer inventoryplayer, World world, BlockPos pos) {
        return new ContainerSearedFurnace(inventoryplayer, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiContainer createGui(InventoryPlayer inventoryplayer, World world, BlockPos pos) {
        return new GuiSearedFurnace((ContainerSearedFurnace)this.createContainer(inventoryplayer, world, pos), this);
    }
}

