/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.multiblock;

import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import slimeknights.mantle.multiblock.IMasterLogic;
import slimeknights.mantle.multiblock.MultiServantLogic;

public abstract class MultiblockDetection {
    public BlockPos detectCenter(World world, BlockPos inside, int limit) {
        int xd1 = 1;
        int xd2 = 1;
        int zd1 = 1;
        int zd2 = 1;
        for (int i = 1; i < limit; ++i) {
            if (this.isInnerBlock(world, inside.func_177982_a(-xd1, 0, 0))) {
                ++xd1;
            } else if (this.isInnerBlock(world, inside.func_177982_a(xd2, 0, 0))) {
                ++xd2;
            }
            if (xd1 - xd2 > 1) {
                --xd1;
                inside = inside.func_177982_a(-1, 0, 0);
                ++xd2;
            }
            if (xd2 - xd1 > 1) {
                --xd2;
                inside = inside.func_177982_a(1, 0, 0);
                ++xd1;
            }
            if (this.isInnerBlock(world, inside.func_177982_a(0, 0, -zd1))) {
                ++zd1;
            } else if (this.isInnerBlock(world, inside.func_177982_a(0, 0, zd2))) {
                ++zd2;
            }
            if (zd1 - zd2 > 1) {
                --zd1;
                inside = inside.func_177982_a(0, 0, -1);
                ++zd2;
            }
            if (zd2 - zd1 <= 1) continue;
            --zd2;
            inside = inside.func_177982_a(0, 0, 1);
            ++zd1;
        }
        return inside;
    }

    protected BlockPos getOuterPos(World world, BlockPos pos, EnumFacing direction, int limit) {
        for (int i = 0; i < limit && this.isInnerBlock(world, pos); ++i) {
            pos = pos.func_177972_a(direction);
        }
        return pos;
    }

    public abstract MultiblockStructure detectMultiblock(World var1, BlockPos var2, int var3);

    public boolean isInnerBlock(World world, BlockPos pos) {
        return world.func_175667_e(pos) && world.func_175623_d(pos);
    }

    public abstract boolean isValidBlock(World var1, BlockPos var2);

    public boolean checkIfMultiblockCanBeRechecked(World world, MultiblockStructure structure) {
        return structure != null && structure.minPos.func_177951_i((Vec3i)structure.maxPos) > 1.0 && world.func_175707_a(structure.minPos, structure.maxPos);
    }

    public static void assignMultiBlock(World world, BlockPos master, List<BlockPos> servants) {
        TileEntity masterBlock = world.func_175625_s(master);
        if (!(masterBlock instanceof IMasterLogic)) {
            throw new IllegalArgumentException("Master must be of IMasterLogic");
        }
        for (BlockPos pos : servants) {
            TileEntity slave;
            if (!world.func_175667_e(pos) || !((slave = world.func_175625_s(pos)) instanceof MultiServantLogic) || slave.func_145831_w() == null) continue;
            ((MultiServantLogic)slave).overrideMaster(master);
            IBlockState state = world.func_180495_p(pos);
            world.func_184138_a(pos, state, state, 3);
        }
    }

    public static class MultiblockStructure {
        public final int xd;
        public final int yd;
        public final int zd;
        public final List<BlockPos> blocks;
        public final BlockPos minPos;
        public final BlockPos maxPos;
        protected final AxisAlignedBB bb;

        public MultiblockStructure(int xd, int yd, int zd, List<BlockPos> blocks) {
            this.xd = xd;
            this.yd = yd;
            this.zd = zd;
            this.blocks = blocks;
            int minx = Integer.MAX_VALUE;
            int maxx = Integer.MIN_VALUE;
            int miny = Integer.MAX_VALUE;
            int maxy = Integer.MIN_VALUE;
            int minz = Integer.MAX_VALUE;
            int maxz = Integer.MIN_VALUE;
            for (BlockPos pos : blocks) {
                if (pos.func_177958_n() < minx) {
                    minx = pos.func_177958_n();
                }
                if (pos.func_177958_n() > maxx) {
                    maxx = pos.func_177958_n();
                }
                if (pos.func_177956_o() < miny) {
                    miny = pos.func_177956_o();
                }
                if (pos.func_177956_o() > maxy) {
                    maxy = pos.func_177956_o();
                }
                if (pos.func_177952_p() < minz) {
                    minz = pos.func_177952_p();
                }
                if (pos.func_177952_p() <= maxz) continue;
                maxz = pos.func_177952_p();
            }
            this.bb = new AxisAlignedBB((double)minx, (double)miny, (double)minz, (double)(maxx + 1), (double)(maxy + 1), (double)(maxz + 1));
            this.minPos = new BlockPos(minx, miny, minz);
            this.maxPos = new BlockPos(maxx, maxy, maxz);
        }

        public AxisAlignedBB getBoundingBox() {
            return this.bb;
        }
    }
}

