/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.natura.world.worldgen;

import com.progwml6.natura.common.config.Config;
import com.progwml6.natura.nether.NaturaNether;
import com.progwml6.natura.nether.block.leaves.BlockNetherLeaves;
import com.progwml6.natura.nether.block.leaves.BlockNetherLeaves2;
import com.progwml6.natura.nether.block.logs.BlockNetherLog;
import com.progwml6.natura.nether.block.logs.BlockNetherLog2;
import com.progwml6.natura.world.worldgen.trees.nether.BloodwoodTreeGenerator;
import com.progwml6.natura.world.worldgen.trees.nether.DarkwoodTreeGenerator;
import com.progwml6.natura.world.worldgen.trees.nether.FusewoodTreeGenerator;
import com.progwml6.natura.world.worldgen.trees.nether.GhostwoodTreeGenerator;
import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;

public class NetherTreesGenerator
implements IWorldGenerator {
    public static NetherTreesGenerator INSTANCE = new NetherTreesGenerator();
    DarkwoodTreeGenerator darkwoodTreeGen;
    FusewoodTreeGenerator fusewoodTreeGen;
    GhostwoodTreeGenerator ghostwoodTreeGen;
    BloodwoodTreeGenerator bloodwoodTreeGen;

    public NetherTreesGenerator() {
        IBlockState netherLog = NaturaNether.netherLog.func_176223_P();
        IBlockState netherLog2 = NaturaNether.netherLog2.func_176223_P();
        IBlockState netherLeaves = NaturaNether.netherLeaves.func_176223_P();
        IBlockState netherLeaves2 = NaturaNether.netherLeaves2.func_176223_P();
        this.darkwoodTreeGen = new DarkwoodTreeGenerator(3, netherLog.func_177226_a(BlockNetherLog.TYPE, (Comparable)((Object)BlockNetherLog.LogType.DARKWOOD)), netherLeaves2.func_177226_a(BlockNetherLeaves2.TYPE, (Comparable)((Object)BlockNetherLeaves2.LeavesType.DARKWOOD)), netherLeaves2.func_177226_a(BlockNetherLeaves2.TYPE, (Comparable)((Object)BlockNetherLeaves2.LeavesType.DARKWOOD_FLOWERING)), netherLeaves2.func_177226_a(BlockNetherLeaves2.TYPE, (Comparable)((Object)BlockNetherLeaves2.LeavesType.DARKWOOD_FRUIT)));
        this.fusewoodTreeGen = new FusewoodTreeGenerator(3, netherLog.func_177226_a(BlockNetherLog.TYPE, (Comparable)((Object)BlockNetherLog.LogType.FUSEWOOD)), netherLeaves.func_177226_a(BlockNetherLeaves.TYPE, (Comparable)((Object)BlockNetherLeaves.LeavesType.FUSEWOOD)));
        this.ghostwoodTreeGen = new GhostwoodTreeGenerator(netherLog.func_177226_a(BlockNetherLog.TYPE, (Comparable)((Object)BlockNetherLog.LogType.GHOSTWOOD)), netherLeaves.func_177226_a(BlockNetherLeaves.TYPE, (Comparable)((Object)BlockNetherLeaves.LeavesType.GHOSTWOOD)), true);
        this.bloodwoodTreeGen = new BloodwoodTreeGenerator(netherLog2.func_177226_a((IProperty)BlockNetherLog2.META, (Comparable)Integer.valueOf(15)), netherLog2.func_177226_a((IProperty)BlockNetherLog2.META, (Comparable)Integer.valueOf(0)), netherLog2.func_177226_a((IProperty)BlockNetherLog2.META, (Comparable)Integer.valueOf(1)), netherLog2.func_177226_a((IProperty)BlockNetherLog2.META, (Comparable)Integer.valueOf(2)), netherLog2.func_177226_a((IProperty)BlockNetherLog2.META, (Comparable)Integer.valueOf(3)), netherLeaves.func_177226_a(BlockNetherLeaves.TYPE, (Comparable)((Object)BlockNetherLeaves.LeavesType.BLOODWOOD)));
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        this.generateNether(random, chunkX, chunkZ, world);
    }

    public void retroGen(Random random, int chunkX, int chunkZ, World world) {
        this.generateNether(random, chunkX, chunkZ, world);
        world.func_72964_e(chunkX, chunkZ).func_76630_e();
    }

    public void generateNether(Random random, int chunkX, int chunkZ, World world) {
        int xPos = chunkX * 16 + 8;
        int zPos = chunkZ * 16 + 8;
        BlockPos chunkPos = new BlockPos(xPos, 0, zPos);
        Biome biome = world.func_175726_f(chunkPos).func_177411_a(chunkPos, world.func_72959_q());
        if (biome == null) {
            return;
        }
        if (this.shouldGenerateInDimension(world.field_73011_w.getDimension()) && BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) {
            BlockPos position;
            int zSpawn;
            int ySpawn;
            int xSpawn;
            if (Config.generateBloodwood && random.nextInt(Config.bloodwoodSpawnRarity) == 0) {
                xSpawn = xPos + random.nextInt(16);
                ySpawn = 72;
                zSpawn = zPos + random.nextInt(16);
                position = new BlockPos(xSpawn, ySpawn, zSpawn);
                this.bloodwoodTreeGen.generateTree(random, world, position);
            }
            if (Config.generateDarkwood && random.nextInt(Config.darkwoodSpawnRarity) == 0) {
                xSpawn = xPos + random.nextInt(16);
                ySpawn = random.nextInt(64) + 32;
                zSpawn = zPos + random.nextInt(16);
                position = new BlockPos(xSpawn, ySpawn, zSpawn);
                this.darkwoodTreeGen.generateTree(random, world, position);
            }
            if (Config.generateFusewood && random.nextInt(Config.fusewoodSpawnRarity) == 0) {
                xSpawn = xPos + random.nextInt(16);
                ySpawn = random.nextInt(64) + 32;
                zSpawn = zPos + random.nextInt(16);
                position = new BlockPos(xSpawn, ySpawn, zSpawn);
                this.fusewoodTreeGen.generateTree(random, world, position);
            }
            if (Config.generateGhostwood && random.nextInt(Config.ghostwoodSpawnRarity) == 0) {
                for (int iter = 0; iter < 3; ++iter) {
                    xSpawn = xPos + random.nextInt(16);
                    ySpawn = random.nextInt(80) + 16;
                    zSpawn = zPos + random.nextInt(16);
                    position = new BlockPos(xSpawn, ySpawn, zSpawn);
                    this.ghostwoodTreeGen.generateTree(random, world, position);
                }
            }
        }
    }

    public boolean shouldGenerateInDimension(int dimension) {
        for (int dimensionId : Config.netherWorldGenBlacklist) {
            if (dimension != dimensionId) continue;
            return false;
        }
        return true;
    }
}

