/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.natura.world.worldgen;

import com.progwml6.natura.common.config.Config;
import com.progwml6.natura.nether.NaturaNether;
import com.progwml6.natura.world.worldgen.berry.nether.NetherBerryBushGenerator;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.fml.common.IWorldGenerator;

public class NetherBerryBushesGenerator
implements IWorldGenerator {
    public static NetherBerryBushesGenerator INSTANCE = new NetherBerryBushesGenerator();
    NetherBerryBushGenerator blightberryBushGen = new NetherBerryBushGenerator(NaturaNether.netherBerryBushBlightberry.func_176223_P());
    NetherBerryBushGenerator duskberryBushGen = new NetherBerryBushGenerator(NaturaNether.netherBerryBushDuskberry.func_176223_P());
    NetherBerryBushGenerator skyberryBushGen = new NetherBerryBushGenerator(NaturaNether.netherBerryBushSkyberry.func_176223_P());
    NetherBerryBushGenerator stingberryBushGen = new NetherBerryBushGenerator(NaturaNether.netherBerryBushStingberry.func_176223_P());

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        this.generateNether(random, chunkX, chunkZ, world);
    }

    public void retroGen(Random random, int chunkX, int chunkZ, World world) {
        this.generateNether(random, chunkX, chunkZ, world);
        world.func_72964_e(chunkX, chunkZ).func_76630_e();
    }

    public void generateNether(Random random, int chunkX, int chunkZ, World world) {
        int xPos = chunkX * 16 + 8;
        int zPos = chunkZ * 16 + 8;
        if (this.shouldGenerateInDimension(world.field_73011_w.getDimension()) && world.field_73011_w.func_177500_n()) {
            BlockPos position;
            int zSpawn;
            int ySpawn;
            int xSpawn;
            if (Config.generateBlightberries && random.nextInt(Config.blightberrySpawnRarity) == 0) {
                xSpawn = xPos + random.nextInt(16);
                ySpawn = random.nextInt(Config.blightberrySpawnRange) + 16;
                zSpawn = zPos + random.nextInt(16);
                position = new BlockPos(xSpawn, ySpawn, zSpawn);
                this.blightberryBushGen.generateBush(random, world, position);
            }
            if (Config.generateDuskberries && random.nextInt(Config.duskberrySpawnRarity) == 0) {
                xSpawn = xPos + random.nextInt(16);
                ySpawn = random.nextInt(Config.duskberrySpawnRange) + 16;
                zSpawn = zPos + random.nextInt(16);
                position = new BlockPos(xSpawn, ySpawn, zSpawn);
                this.duskberryBushGen.generateBush(random, world, position);
            }
            if (Config.generateSkyberries && random.nextInt(Config.skyberrySpawnRarity) == 0) {
                xSpawn = xPos + random.nextInt(16);
                ySpawn = random.nextInt(Config.skyberrySpawnRange) + 16;
                zSpawn = zPos + random.nextInt(16);
                position = new BlockPos(xSpawn, ySpawn, zSpawn);
                this.skyberryBushGen.generateBush(random, world, position);
            }
            if (Config.generateStingberries && random.nextInt(Config.stingberrySpawnRarity) == 0) {
                xSpawn = xPos + random.nextInt(16);
                ySpawn = random.nextInt(Config.stingberrySpawnRange) + 16;
                zSpawn = zPos + random.nextInt(16);
                position = new BlockPos(xSpawn, ySpawn, zSpawn);
                this.stingberryBushGen.generateBush(random, world, position);
            }
        }
    }

    public boolean shouldGenerateInDimension(int dimension) {
        for (int dimensionId : Config.netherWorldGenBlacklist) {
            if (dimension != dimensionId) continue;
            return false;
        }
        return true;
    }
}

