/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.natura.decorative;

import com.google.common.eventbus.Subscribe;
import com.progwml6.natura.common.CommonProxy;
import com.progwml6.natura.common.NaturaPulse;
import com.progwml6.natura.decorative.block.bookshelves.BlockNetherBookshelves;
import com.progwml6.natura.decorative.block.bookshelves.BlockOverworldBookshelves;
import com.progwml6.natura.decorative.block.workbenches.BlockNetherWorkbenches;
import com.progwml6.natura.decorative.block.workbenches.BlockOverworldWorkbenches;
import com.progwml6.natura.library.Util;
import com.progwml6.natura.library.enums.WoodTypes;
import com.progwml6.natura.nether.NaturaNether;
import com.progwml6.natura.nether.block.planks.BlockNetherPlanks;
import com.progwml6.natura.overworld.NaturaOverworld;
import com.progwml6.natura.overworld.block.planks.BlockOverworldPlanks;
import com.progwml6.natura.shared.NaturaCommons;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.pulsar.pulse.Pulse;

@Pulse(id="NaturaDecorative", description="Everything that's decorative for Natura. (bookshelfs, etc)")
public class NaturaDecorative
extends NaturaPulse {
    public static final String PulseId = "NaturaDecorative";
    static final Logger log = Util.getLogger("NaturaDecorative");
    @SidedProxy(clientSide="com.progwml6.natura.decorative.DecorativeClientProxy", serverSide="com.progwml6.natura.common.CommonProxy")
    public static CommonProxy proxy;
    public static Block[] buttons;
    public static Block[] pressurePlates;
    public static Block[] trapDoors;
    public static Block[] fences;
    public static Block[] fenceGates;
    public static BlockOverworldBookshelves overworldBookshelves;
    public static BlockNetherBookshelves netherBookshelves;
    public static BlockOverworldWorkbenches overworldWorkbenches;
    public static BlockNetherWorkbenches netherWorkbenches;

    @Subscribe
    public void preInit(FMLPreInitializationEvent event) {
        if (NaturaDecorative.isOverworldLoaded()) {
            for (WoodTypes type : WoodTypes.values()) {
                if (type.getWorldType() != WoodTypes.WorldType.OVERWORLD) continue;
                NaturaDecorative.buttons[type.ordinal()] = NaturaDecorative.registerBlockButton(type.func_176610_l() + "_button");
                NaturaDecorative.pressurePlates[type.ordinal()] = NaturaDecorative.registerBlockPressurePlate(type.func_176610_l() + "_pressure_plate");
                NaturaDecorative.trapDoors[type.ordinal()] = NaturaDecorative.registerBlockTrapDoor(type.func_176610_l() + "_trap_door");
                NaturaDecorative.fences[type.ordinal()] = NaturaDecorative.registerBlockFence(type.func_176610_l() + "_fence");
                NaturaDecorative.fenceGates[type.ordinal()] = NaturaDecorative.registerBlockFenceGate(type.func_176610_l() + "_fence_gate");
            }
            overworldBookshelves = NaturaDecorative.registerEnumBlock(new BlockOverworldBookshelves(), "overworld_bookshelves");
            overworldWorkbenches = NaturaDecorative.registerEnumBlock(new BlockOverworldWorkbenches(), "overworld_workbenches");
        }
        if (NaturaDecorative.isNetherLoaded()) {
            for (WoodTypes type : WoodTypes.values()) {
                if (type.getWorldType() != WoodTypes.WorldType.NETHER) continue;
                NaturaDecorative.buttons[type.ordinal()] = NaturaDecorative.registerBlockButton(type.func_176610_l() + "_button");
                NaturaDecorative.pressurePlates[type.ordinal()] = NaturaDecorative.registerBlockPressurePlate(type.func_176610_l() + "_pressure_plate");
                NaturaDecorative.trapDoors[type.ordinal()] = NaturaDecorative.registerBlockTrapDoor(type.func_176610_l() + "_trap_door");
                NaturaDecorative.fences[type.ordinal()] = NaturaDecorative.registerBlockFence(type.func_176610_l() + "_fence");
                NaturaDecorative.fenceGates[type.ordinal()] = NaturaDecorative.registerBlockFenceGate(type.func_176610_l() + "_fence_gate");
            }
            netherBookshelves = NaturaDecorative.registerEnumBlock(new BlockNetherBookshelves(), "nether_bookshelves");
            netherWorkbenches = NaturaDecorative.registerEnumBlock(new BlockNetherWorkbenches(), "nether_workbenches");
        }
        proxy.preInit();
    }

    @Subscribe
    public void init(FMLInitializationEvent event) {
        proxy.init();
        this.registerRecipes();
    }

    @Subscribe
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit();
    }

    private void registerRecipes() {
        if (NaturaDecorative.isOverworldLoaded()) {
            for (WoodTypes woodTypes : WoodTypes.values()) {
                if (woodTypes.getWorldType() != WoodTypes.WorldType.OVERWORLD) continue;
                this.addShapedRecipe(new ItemStack(buttons[woodTypes.ordinal()], 1), "#", Character.valueOf('#'), new ItemStack((Block)NaturaOverworld.overworldPlanks, 1, woodTypes.getPlankMeta()));
                this.addShapedRecipe(new ItemStack(pressurePlates[woodTypes.ordinal()], 1), "##", Character.valueOf('#'), new ItemStack((Block)NaturaOverworld.overworldPlanks, 1, woodTypes.getPlankMeta()));
                this.addShapedRecipe(new ItemStack(trapDoors[woodTypes.ordinal()], 2), "###", "###", Character.valueOf('#'), new ItemStack((Block)NaturaOverworld.overworldPlanks, 1, woodTypes.getPlankMeta()));
                this.addShapedRecipe(new ItemStack(fences[woodTypes.ordinal()], 2), "###", "###", Character.valueOf('#'), new ItemStack((Item)NaturaCommons.sticks, 1, woodTypes.getStickMeta()));
                this.addShapedRecipe(new ItemStack(fenceGates[woodTypes.ordinal()], 1), "s#s", "s#s", Character.valueOf('#'), new ItemStack((Block)NaturaOverworld.overworldPlanks, 1, woodTypes.getPlankMeta()), Character.valueOf('s'), new ItemStack((Item)NaturaCommons.sticks, 1, woodTypes.getStickMeta()));
            }
            for (Enum enum_ : BlockOverworldPlanks.PlankType.values()) {
                this.addShapedRecipe(new ItemStack((Block)overworldWorkbenches, 1, ((BlockOverworldPlanks.PlankType)enum_).getMeta()), "##", "##", Character.valueOf('#'), new ItemStack((Block)NaturaOverworld.overworldPlanks, 1, ((BlockOverworldPlanks.PlankType)enum_).getMeta()));
                this.addShapedRecipe(new ItemStack((Block)overworldBookshelves, 1, ((BlockOverworldPlanks.PlankType)enum_).getMeta()), "###", "bbb", "###", Character.valueOf('#'), new ItemStack((Block)NaturaOverworld.overworldPlanks, 1, ((BlockOverworldPlanks.PlankType)enum_).getMeta()), Character.valueOf('b'), Items.field_151122_aG);
            }
        }
        if (NaturaDecorative.isNetherLoaded()) {
            for (Enum enum_ : WoodTypes.values()) {
                if (((WoodTypes)enum_).getWorldType() != WoodTypes.WorldType.NETHER) continue;
                this.addShapedRecipe(new ItemStack(buttons[enum_.ordinal()], 1), "#", Character.valueOf('#'), new ItemStack((Block)NaturaNether.netherPlanks, 1, ((WoodTypes)enum_).getPlankMeta()));
                this.addShapedRecipe(new ItemStack(pressurePlates[enum_.ordinal()], 1), "##", Character.valueOf('#'), new ItemStack((Block)NaturaNether.netherPlanks, 1, ((WoodTypes)enum_).getPlankMeta()));
                this.addShapedRecipe(new ItemStack(trapDoors[enum_.ordinal()], 2), "###", "###", Character.valueOf('#'), new ItemStack((Block)NaturaNether.netherPlanks, 1, ((WoodTypes)enum_).getPlankMeta()));
                this.addShapedRecipe(new ItemStack(fences[enum_.ordinal()], 2), "###", "###", Character.valueOf('#'), new ItemStack((Item)NaturaCommons.sticks, 1, ((WoodTypes)enum_).getStickMeta()));
                this.addShapedRecipe(new ItemStack(fenceGates[enum_.ordinal()], 1), "s#s", "s#s", Character.valueOf('#'), new ItemStack((Block)NaturaNether.netherPlanks, 1, ((WoodTypes)enum_).getPlankMeta()), Character.valueOf('s'), new ItemStack((Item)NaturaCommons.sticks, 1, ((WoodTypes)enum_).getStickMeta()));
            }
            for (Enum enum_ : BlockNetherPlanks.PlankType.values()) {
                this.addShapedRecipe(new ItemStack((Block)netherWorkbenches, 1, ((BlockNetherPlanks.PlankType)enum_).getMeta()), "##", "##", Character.valueOf('#'), new ItemStack((Block)NaturaNether.netherPlanks, 1, ((BlockNetherPlanks.PlankType)enum_).getMeta()));
                this.addShapedRecipe(new ItemStack((Block)netherBookshelves, 1, ((BlockNetherPlanks.PlankType)enum_).getMeta()), "###", "bbb", "###", Character.valueOf('#'), new ItemStack((Block)NaturaNether.netherPlanks, 1, ((BlockNetherPlanks.PlankType)enum_).getMeta()), Character.valueOf('b'), Items.field_151122_aG);
            }
        }
    }

    static {
        buttons = new Block[WoodTypes.values().length];
        pressurePlates = new Block[WoodTypes.values().length];
        trapDoors = new Block[WoodTypes.values().length];
        fences = new Block[WoodTypes.values().length];
        fenceGates = new Block[WoodTypes.values().length];
    }
}

