/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.natura.common;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.progwml6.natura.Natura;
import com.progwml6.natura.common.block.BlockGrassStairs;
import com.progwml6.natura.common.block.base.BlockButtonBase;
import com.progwml6.natura.common.block.base.BlockFenceBase;
import com.progwml6.natura.common.block.base.BlockFenceGateBase;
import com.progwml6.natura.common.block.base.BlockNaturaStairsBase;
import com.progwml6.natura.common.block.base.BlockPressurePlateBase;
import com.progwml6.natura.common.block.base.BlockTrapDoorBase;
import com.progwml6.natura.library.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IStringSerializable;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import slimeknights.mantle.block.EnumBlock;
import slimeknights.mantle.block.EnumBlockSlab;
import slimeknights.mantle.item.ItemBlockMeta;
import slimeknights.mantle.item.ItemBlockSlab;

public abstract class NaturaPulse {
    protected static boolean isEntitiesLoaded() {
        return Natura.pulseManager.isPulseLoaded("NaturaEntities");
    }

    protected static boolean isWorldLoaded() {
        return Natura.pulseManager.isPulseLoaded("NaturaWorld");
    }

    protected static boolean isOverworldLoaded() {
        return Natura.pulseManager.isPulseLoaded("NaturaOverworld");
    }

    protected static boolean isNetherLoaded() {
        return Natura.pulseManager.isPulseLoaded("NaturaNether");
    }

    protected static boolean isDecorativeLoaded() {
        return Natura.pulseManager.isPulseLoaded("NaturaDecorative");
    }

    protected static <T extends Item> T registerItem(T item, String name) {
        if (!name.equals(name.toLowerCase(Locale.US))) {
            throw new IllegalArgumentException(String.format("Unlocalized names need to be all lowercase! Item: %s", name));
        }
        item.func_77655_b(Util.prefix(name));
        item.setRegistryName(Util.getResource(name));
        GameRegistry.register(item);
        return item;
    }

    protected static <T extends Block> T registerBlock(T block, String name) {
        ItemBlockMeta itemBlock = new ItemBlockMeta(block);
        NaturaPulse.registerBlock(block, (ItemBlock)itemBlock, name);
        return block;
    }

    protected static <T extends EnumBlock<?>> T registerEnumBlock(T block, String name) {
        NaturaPulse.registerBlock(block, (ItemBlock)new ItemBlockMeta(block), name);
        ItemBlockMeta.setMappingProperty(block, (IProperty)block.prop);
        return block;
    }

    protected static <T extends EnumBlockSlab<?>> T registerEnumBlockSlab(T block, String name) {
        NaturaPulse.registerBlock(block, (ItemBlock)new ItemBlockSlab(block), name);
        ItemBlockMeta.setMappingProperty(block, (IProperty)block.prop);
        return block;
    }

    protected static <E extends Enum<E> & IStringSerializable> BlockNaturaStairsBase registerBlockStairsFrom(EnumBlock<E> block, E value, String name) {
        return NaturaPulse.registerBlock(new BlockNaturaStairsBase(block.func_176223_P().func_177226_a((IProperty)block.prop, value)), name);
    }

    protected static <E extends Enum<E> & IStringSerializable> BlockGrassStairs registerBlockGrassStairsFrom(EnumBlock<E> block, E value, String name) {
        return NaturaPulse.registerBlock(new BlockGrassStairs(block.func_176223_P().func_177226_a((IProperty)block.prop, value)), name);
    }

    protected static BlockButtonBase registerBlockButton(String name) {
        return NaturaPulse.registerBlock(new BlockButtonBase(), name);
    }

    protected static BlockPressurePlateBase registerBlockPressurePlate(String name) {
        return NaturaPulse.registerBlock(new BlockPressurePlateBase(), name);
    }

    protected static BlockTrapDoorBase registerBlockTrapDoor(String name) {
        return NaturaPulse.registerBlock(new BlockTrapDoorBase(), name);
    }

    protected static BlockFenceBase registerBlockFence(String name) {
        return NaturaPulse.registerBlock(new BlockFenceBase(), name);
    }

    protected static BlockFenceGateBase registerBlockFenceGate(String name) {
        return NaturaPulse.registerBlock(new BlockFenceGateBase(), name);
    }

    protected static <T extends Block> T registerBlock(ItemBlock itemBlock, String name) {
        Block block = itemBlock.func_179223_d();
        return (T)NaturaPulse.registerBlock(block, itemBlock, name);
    }

    protected static <T extends Block> T registerBlock(T block, String name, IProperty<?> property) {
        ItemBlockMeta itemBlock = new ItemBlockMeta(block);
        NaturaPulse.registerBlock(block, (ItemBlock)itemBlock, name);
        ItemBlockMeta.setMappingProperty(block, property);
        return block;
    }

    protected static <T extends Block> T registerBlock(T block, ItemBlock itemBlock, String name) {
        if (!name.equals(name.toLowerCase(Locale.US))) {
            throw new IllegalArgumentException(String.format("Unlocalized names need to be all lowercase! Block: %s", name));
        }
        String prefixedName = Util.prefix(name);
        block.func_149663_c(prefixedName);
        itemBlock.func_77655_b(prefixedName);
        NaturaPulse.register(block, name);
        NaturaPulse.register(itemBlock, name);
        return block;
    }

    protected static <T extends Block> T registerBlockNoItem(T block, String name) {
        if (!name.equals(name.toLowerCase(Locale.US))) {
            throw new IllegalArgumentException(String.format("Unlocalized names need to be all lowercase! Block: %s", name));
        }
        String prefixedName = Util.prefix(name);
        block.func_149663_c(prefixedName);
        NaturaPulse.register(block, name);
        return block;
    }

    protected static <T extends IForgeRegistryEntry<?>> T register(T thing, String name) {
        thing.setRegistryName(Util.getResource(name));
        GameRegistry.register(thing);
        return thing;
    }

    protected static void registerTE(Class<? extends TileEntity> teClazz, String name) {
        if (!name.equals(name.toLowerCase(Locale.US))) {
            throw new IllegalArgumentException(String.format("Unlocalized names need to be all lowercase! TE: %s", name));
        }
        GameRegistry.registerTileEntity(teClazz, (String)Util.prefix(name));
    }

    protected void addShapedRecipe(ItemStack stack, Object ... recipeComponents) {
        String s = "";
        int i = 0;
        int j = 0;
        int k = 0;
        if (recipeComponents[i] instanceof String[]) {
            String[] astring;
            for (String s2 : astring = (String[])recipeComponents[i++]) {
                ++k;
                j = s2.length();
                s = s + s2;
            }
        } else {
            while (recipeComponents[i] instanceof String) {
                String s1 = (String)recipeComponents[i++];
                ++k;
                j = s1.length();
                s = s + s1;
            }
        }
        HashMap map = Maps.newHashMap();
        while (i < recipeComponents.length) {
            Character character = (Character)recipeComponents[i];
            ItemStack itemstack = null;
            if (recipeComponents[i + 1] instanceof Item) {
                itemstack = new ItemStack((Item)recipeComponents[i + 1]);
            } else if (recipeComponents[i + 1] instanceof Block) {
                itemstack = new ItemStack((Block)recipeComponents[i + 1], 1, Short.MAX_VALUE);
            } else if (recipeComponents[i + 1] instanceof ItemStack) {
                itemstack = (ItemStack)recipeComponents[i + 1];
            }
            map.put(character, itemstack);
            i += 2;
        }
        ItemStack[] aitemstack = new ItemStack[j * k];
        for (int l = 0; l < j * k; ++l) {
            char c0 = s.charAt(l);
            aitemstack[l] = map.containsKey(Character.valueOf(c0)) ? ((ItemStack)map.get(Character.valueOf(c0))).func_77946_l() : null;
        }
        ShapedRecipes shapedrecipes = new ShapedRecipes(j, k, aitemstack, stack);
        CraftingManager.func_77594_a().func_77592_b().add(shapedrecipes);
    }

    protected void addShapelessRecipe(ItemStack stack, Object ... recipeComponents) {
        ArrayList list = Lists.newArrayList();
        for (Object object : recipeComponents) {
            if (object instanceof ItemStack) {
                list.add(((ItemStack)object).func_77946_l());
                continue;
            }
            if (object instanceof Item) {
                list.add(new ItemStack((Item)object));
                continue;
            }
            if (!(object instanceof Block)) {
                throw new IllegalArgumentException("Invalid shapeless recipe: unknown type " + object.getClass().getName() + "!");
            }
            list.add(new ItemStack((Block)object));
        }
        CraftingManager.func_77594_a().func_77592_b().add(new ShapelessRecipes(stack, (List)list));
    }

    protected static void addSlabRecipe(ItemStack slab, ItemStack input) {
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(slab.func_77973_b(), 6, slab.func_77952_i()), (Object[])new Object[]{"BBB", Character.valueOf('B'), input});
    }

    protected static void addSlabRecipe(Block slab, int slabMeta, ItemStack input) {
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(slab, 6, slabMeta), (Object[])new Object[]{"BBB", Character.valueOf('B'), input});
    }

    protected static void addStairRecipe(Block stairs, ItemStack input) {
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(stairs, 4, 0), (Object[])new Object[]{"B  ", "BB ", "BBB", Character.valueOf('B'), input});
    }
}

