/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins.compat;

import forestry.api.core.ForestryAPI;
import forestry.api.farming.Farmables;
import forestry.api.farming.ICrop;
import forestry.api.fuels.FuelManager;
import forestry.api.fuels.GeneratorFuel;
import forestry.api.recipes.RecipeManagers;
import forestry.core.fluids.Fluids;
import forestry.core.utils.ModUtil;
import forestry.farming.logic.CropDestroy;
import forestry.farming.logic.FarmableBase;
import forestry.plugins.BlankForestryPlugin;
import forestry.plugins.ForestryPlugin;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

@ForestryPlugin(pluginID="forestry.immersiveengineering", name="ImmersiveEngineering", author="marcin212", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.immersiveengineering.description")
public class PluginImmersiveEngineering
extends BlankForestryPlugin {
    private static final String IE = "immersiveengineering";

    @Override
    public boolean isAvailable() {
        return ModUtil.isModLoaded(IE);
    }

    @Override
    public String getFailMessage() {
        return "ImmersiveEngineering not found";
    }

    @Override
    public void postInit() {
        Fluid ethanol;
        ItemStack hempSeed = PluginImmersiveEngineering.getItemStack("seed");
        Block hempCrop = PluginImmersiveEngineering.getBlock("hemp");
        int seedAmount = ForestryAPI.activeMode.getIntegerSetting("squeezer.liquid.seed");
        IProperty age = hempCrop.func_176194_O().func_177623_d().stream().filter(p -> p.func_177701_a().equals("type")).findAny().get();
        if (hempSeed != null && hempCrop != null && age != null) {
            IBlockState planted = hempCrop.func_176223_P().func_177226_a(age, (Comparable)age.func_185929_b("bottom0").get());
            IBlockState mature = hempCrop.func_176223_P().func_177226_a(age, (Comparable)age.func_185929_b("top0").get());
            Farmables.farmables.get((Object)"farmWheat").add(new FarmableBase(hempSeed, planted, mature, false){

                @Override
                public ICrop getCropAt(World world, BlockPos pos, IBlockState blockState) {
                    IBlockState stateUp = world.func_180495_p(pos.func_177984_a());
                    if (stateUp != this.matureState) {
                        return null;
                    }
                    return new CropDestroy(world, stateUp, pos.func_177984_a(), null);
                }
            });
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{hempSeed}, Fluids.SEED_OIL.getFluid(seedAmount));
        }
        if ((ethanol = FluidRegistry.getFluid((String)"ethanol")) != null) {
            GeneratorFuel ethanolFuel = new GeneratorFuel(new FluidStack(ethanol, 1), (int)(32.0f * ForestryAPI.activeMode.getFloatSetting("fuel.ethanol.generator")), 4);
            FuelManager.generatorFuel.put(ethanol, ethanolFuel);
        }
    }

    private static Block getBlock(@Nonnull String blockName) {
        ResourceLocation key = new ResourceLocation(IE, blockName);
        if (ForgeRegistries.BLOCKS.containsKey(key)) {
            return (Block)ForgeRegistries.BLOCKS.getValue(key);
        }
        return null;
    }

    @Nullable
    private static ItemStack getItemStack(@Nonnull String itemName, int meta) {
        ResourceLocation key = new ResourceLocation(IE, itemName);
        if (ForgeRegistries.ITEMS.containsKey(key)) {
            return new ItemStack((Item)ForgeRegistries.ITEMS.getValue(key), 1, meta);
        }
        return null;
    }

    @Nullable
    private static ItemStack getItemStack(@Nonnull String itemName) {
        return PluginImmersiveEngineering.getItemStack(itemName, 0);
    }
}

