/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins.compat;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import forestry.api.core.ForestryAPI;
import forestry.api.farming.Farmables;
import forestry.api.fuels.FuelManager;
import forestry.api.fuels.MoistenerFuel;
import forestry.api.recipes.RecipeManagers;
import forestry.core.PluginCore;
import forestry.core.PluginFluids;
import forestry.core.fluids.Fluids;
import forestry.core.recipes.RecipeUtil;
import forestry.core.utils.ModUtil;
import forestry.farming.logic.FarmableAgingCrop;
import forestry.plugins.BlankForestryPlugin;
import forestry.plugins.ForestryPlugin;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

@ForestryPlugin(pluginID="forestry.harvestcraft", name="HarvestCraft", author="Nirek", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.harvestcraft.description")
public class PluginHarvestCraft
extends BlankForestryPlugin {
    private static final String HC = "harvestcraft";

    @Override
    public boolean isAvailable() {
        return ModUtil.isModLoaded(HC);
    }

    @Override
    public String getFailMessage() {
        return "HarvestCraft not found";
    }

    @Nullable
    private static ItemStack getItemStack(@Nonnull String itemName) {
        ResourceLocation key = new ResourceLocation(HC, itemName);
        if (ForgeRegistries.ITEMS.containsKey(key)) {
            return new ItemStack((Item)ForgeRegistries.ITEMS.getValue(key), 1);
        }
        return null;
    }

    private static Block getBlock(@Nonnull String blockName) {
        ResourceLocation key = new ResourceLocation(HC, blockName);
        if (ForgeRegistries.BLOCKS.containsKey(key)) {
            return (Block)ForgeRegistries.BLOCKS.getValue(key);
        }
        return null;
    }

    @Override
    public void registerRecipes() {
        ItemStack hcBeeswaxItem;
        Block fruitBlock;
        ImmutableList berries = ImmutableList.of((Object)"cranberry", (Object)"blackberry", (Object)"blueberry", (Object)"raspberry", (Object)"strawberry");
        ImmutableList fruits = ImmutableList.of((Object)"pineapple", (Object)"cactusfruit", (Object)"cantaloupe", (Object)"grape", (Object)"kiwi", (Object)"chilipepper");
        ImmutableList treeFruits = ImmutableList.of((Object)"banana", (Object)"dragonfruit", (Object)"lemon", (Object)"lime", (Object)"mango", (Object)"orange", (Object)"papaya", (Object)"peach", (Object)"pear", (Object)"plum", (Object)"pomegranate", (Object)"starfruit", (Object[])new String[]{"apricot", "date", "fig", "grapefruit", "persimmon", "avocado", "coconut", "durian"});
        ImmutableList trees = ImmutableList.of((Object)"nutmeg", (Object)"olive", (Object)"peppercorn");
        ImmutableList treesSpecial = ImmutableList.of((Object)"cinnamon", (Object)"maple", (Object)"paperbark", (Object)"vanillabean", (Object)"apple");
        ImmutableList herbs = ImmutableList.of((Object)"garlic");
        ImmutableList spices = ImmutableList.of((Object)"ginger", (Object)"spiceleaf");
        ImmutableList vegetables = ImmutableList.of((Object)"asparagus", (Object)"bean", (Object)"beet", (Object)"broccoli", (Object)"cauliflower", (Object)"celery", (Object)"leek", (Object)"lettuce", (Object)"onion", (Object)"parsnip", (Object)"radish", (Object)"rutabaga", (Object[])new String[]{"scallion", "soybean", "sweetpotato", "turnip", "whitemushroom", "artichoke", "bellpepper", "brusselsprout", "cabbage", "corn", "cucumber", "eggplant", "okra", "peas", "rhubarb", "seaweed", "tomato", "wintersquash", "zucchini", "bambooshoot", "spinach"});
        ImmutableList grains = ImmutableList.of((Object)"barley", (Object)"oats", (Object)"rye");
        ImmutableList cropNuts = ImmutableList.of((Object)"peanut");
        ImmutableList nuts = ImmutableList.of((Object)"walnut", (Object)"almond", (Object)"cashew", (Object)"chestnut", (Object)"pecan", (Object)"pistachio", (Object)"cherry");
        ImmutableList.Builder genericCropsBuilder = ImmutableList.builder();
        genericCropsBuilder.add((Object[])new String[]{"cotton", "rice", "tealeaf", "coffeebean", "candleberry"});
        genericCropsBuilder.addAll((Iterable)herbs);
        genericCropsBuilder.addAll((Iterable)spices);
        ImmutableList genericCrops = genericCropsBuilder.build();
        ImmutableList.Builder plants = ImmutableList.builder();
        int juiceAmount = ForestryAPI.activeMode.getIntegerSetting("squeezer.liquid.apple") / 25;
        int seedamount = ForestryAPI.activeMode.getIntegerSetting("squeezer.liquid.seed");
        int wheatamount = ForestryAPI.activeMode.getIntegerSetting("recipe.output.compost.wheat");
        PropertyInteger plantAGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)3);
        PropertyInteger fruitAGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)2);
        juiceAmount = Math.max(juiceAmount, 1);
        for (String berryName : berries) {
            ItemStack berry = PluginHarvestCraft.getItemStack(berryName + "item");
            ItemStack berrySeed = PluginHarvestCraft.getItemStack(berryName + "seeditem");
            Block berryBlock = PluginHarvestCraft.getBlock("pam" + berryName + "crop");
            if (berry != null) {
                RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{berry}, Fluids.JUICE.getFluid(juiceAmount));
            }
            if (berrySeed != null) {
                RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{berrySeed}, Fluids.SEED_OIL.getFluid(seedamount));
            }
            if (ForestryAPI.enabledPlugins.contains("forestry.farming") && berrySeed != null && berryBlock != null) {
                Farmables.farmables.get((Object)"farmWheat").add(new FarmableAgingCrop(berrySeed, berryBlock, (IProperty<Integer>)plantAGE, 3));
                Farmables.farmables.get((Object)"farmOrchard").add(new FarmableAgingCrop(berrySeed, berryBlock, (IProperty<Integer>)plantAGE, 3, 0));
            }
            plants.add((Object)berryName);
        }
        juiceAmount = ForestryAPI.activeMode.getIntegerSetting("squeezer.liquid.apple");
        for (String fruitName : fruits) {
            ItemStack fruit = PluginHarvestCraft.getItemStack(fruitName + "item");
            ItemStack fruitSeed = PluginHarvestCraft.getItemStack(fruitName + "seeditem");
            Block fruitBlock2 = PluginHarvestCraft.getBlock("pam" + fruitName + "crop");
            if (fruit != null) {
                RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{fruit}, Fluids.JUICE.getFluid(juiceAmount));
            }
            if (fruitSeed != null) {
                RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{fruitSeed}, Fluids.SEED_OIL.getFluid(seedamount));
            }
            if (ForestryAPI.enabledPlugins.contains("forestry.farming") && fruitSeed != null && fruitBlock2 != null) {
                Farmables.farmables.get((Object)"farmWheat").add(new FarmableAgingCrop(fruitSeed, fruitBlock2, (IProperty<Integer>)plantAGE, 3));
                Farmables.farmables.get((Object)"farmOrchard").add(new FarmableAgingCrop(fruitSeed, fruitBlock2, (IProperty<Integer>)plantAGE, 3, 0));
            }
            plants.add((Object)fruitName);
        }
        juiceAmount = ForestryAPI.activeMode.getIntegerSetting("squeezer.liquid.apple") / 2;
        juiceAmount = Math.max(juiceAmount, 1);
        for (String vegetableName : vegetables) {
            ItemStack vegetable = PluginHarvestCraft.getItemStack(vegetableName + "item");
            ItemStack vegetableSeed = PluginHarvestCraft.getItemStack(vegetableName + "seeditem");
            Block vegetableBlock = PluginHarvestCraft.getBlock("pam" + vegetableName + "crop");
            if (vegetable != null) {
                RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{vegetable}, Fluids.JUICE.getFluid(juiceAmount));
            }
            if (vegetableSeed != null) {
                RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{vegetableSeed}, Fluids.SEED_OIL.getFluid(seedamount));
            }
            if (ForestryAPI.enabledPlugins.contains("forestry.farming") && vegetableSeed != null && vegetableBlock != null) {
                Farmables.farmables.get((Object)"farmVegetables").add(new FarmableAgingCrop(vegetableSeed, vegetableBlock, (IProperty<Integer>)plantAGE, 3));
                Farmables.farmables.get((Object)"farmOrchard").add(new FarmableAgingCrop(vegetableSeed, vegetableBlock, (IProperty<Integer>)plantAGE, 3, 0));
            }
            plants.add((Object)vegetableName);
        }
        for (String grainName : grains) {
            ItemStack grain = PluginHarvestCraft.getItemStack(grainName + "item");
            ItemStack grainSeed = PluginHarvestCraft.getItemStack(grainName + "seeditem");
            Block grainBlock = PluginHarvestCraft.getBlock("pam" + grainName + "crop");
            if (grain != null && wheatamount > 0) {
                RecipeUtil.addRecipe(PluginCore.items.fertilizerBio.getItemStack(wheatamount), " X ", "X#X", " X ", Character.valueOf('#'), Blocks.field_150346_d, Character.valueOf('X'), grain);
                FuelManager.moistenerResource.put(grain, new MoistenerFuel(grain, PluginCore.items.mouldyWheat.getItemStack(), 0, 300));
            }
            if (grainSeed != null) {
                RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{grainSeed}, Fluids.SEED_OIL.getFluid(seedamount));
                RecipeManagers.moistenerManager.addRecipe(grainSeed, new ItemStack((Block)Blocks.field_150391_bh), 5000);
            }
            if (ForestryAPI.enabledPlugins.contains("forestry.farming") && grainSeed != null && grainBlock != null) {
                Farmables.farmables.get((Object)"farmWheat").add(new FarmableAgingCrop(grainSeed, grainBlock, (IProperty<Integer>)plantAGE, 3));
                Farmables.farmables.get((Object)"farmOrchard").add(new FarmableAgingCrop(grainSeed, grainBlock, (IProperty<Integer>)plantAGE, 3, 0));
            }
            plants.add((Object)grainName);
        }
        for (String treeFruitName : treeFruits) {
            ItemStack treeFruit = PluginHarvestCraft.getItemStack(treeFruitName + "item");
            Block treeFruitBlock = PluginHarvestCraft.getBlock("pam" + treeFruitName);
            if (ForestryAPI.enabledPlugins.contains("forestry.farming") && treeFruitBlock != null) {
                Farmables.farmables.get((Object)"farmOrchard").add(new FarmableAgingCrop(null, treeFruitBlock, (IProperty<Integer>)fruitAGE, 2, 0));
            }
            if (treeFruit != null) {
                RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{treeFruit}, Fluids.JUICE.getFluid(juiceAmount));
            }
            plants.add((Object)treeFruitName);
        }
        for (String treeName : trees) {
            fruitBlock = PluginHarvestCraft.getBlock("pam" + treeName);
            if (ForestryAPI.enabledPlugins.contains("forestry.farming") && fruitBlock != null) {
                Farmables.farmables.get((Object)"farmOrchard").add(new FarmableAgingCrop(null, fruitBlock, (IProperty<Integer>)fruitAGE, 2, 0));
            }
            plants.add((Object)treeName);
        }
        for (String treeName : treesSpecial) {
            fruitBlock = PluginHarvestCraft.getBlock("pam" + treeName);
            if (!ForestryAPI.enabledPlugins.contains("forestry.farming") || fruitBlock == null) continue;
            Farmables.farmables.get((Object)"farmOrchard").add(new FarmableAgingCrop(null, fruitBlock, (IProperty<Integer>)fruitAGE, 2, 0));
        }
        for (String cropName : genericCrops) {
            String seedPrefix = cropName;
            if (seedPrefix.equals("tealeaf")) {
                seedPrefix = "tea";
            }
            if (seedPrefix.equals("coffeebean")) {
                seedPrefix = "coffee";
            }
            UnmodifiableIterator genericCropSeed = PluginHarvestCraft.getItemStack(seedPrefix + "seeditem");
            Block genericCropBlock = PluginHarvestCraft.getBlock("pam" + cropName + "crop");
            if (genericCropSeed != null) {
                RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{genericCropSeed}, Fluids.SEED_OIL.getFluid(seedamount));
            }
            if (ForestryAPI.enabledPlugins.contains("forestry.farming") && genericCropSeed != null && genericCropBlock != null) {
                Farmables.farmables.get((Object)"farmWheat").add(new FarmableAgingCrop((ItemStack)genericCropSeed, genericCropBlock, (IProperty<Integer>)plantAGE, 3));
                Farmables.farmables.get((Object)"farmOrchard").add(new FarmableAgingCrop((ItemStack)genericCropSeed, genericCropBlock, (IProperty<Integer>)plantAGE, 3, 0));
            }
            plants.add((Object)cropName);
        }
        ItemStack mustardCropSeed = PluginHarvestCraft.getItemStack("mustardseeditem");
        Block mustardCropBlock = PluginHarvestCraft.getBlock("pammustardseedscrop");
        ItemStack mustardFruit = PluginHarvestCraft.getItemStack("mustardseedsitem");
        if (mustardCropSeed != null) {
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{mustardCropSeed}, Fluids.SEED_OIL.getFluid(seedamount));
        }
        if (ForestryAPI.enabledPlugins.contains("forestry.farming") && mustardCropSeed != null && mustardCropBlock != null) {
            Farmables.farmables.get((Object)"farmWheat").add(new FarmableAgingCrop(mustardCropSeed, mustardCropBlock, (IProperty<Integer>)plantAGE, 3));
            Farmables.farmables.get((Object)"farmOrchard").add(new FarmableAgingCrop(mustardCropSeed, mustardCropBlock, (IProperty<Integer>)plantAGE, 3, 0));
        }
        if (mustardFruit != null) {
            RecipeUtil.addFermenterRecipes(mustardFruit, ForestryAPI.activeMode.getIntegerSetting("fermenter.yield.wheat"), Fluids.BIOMASS);
        }
        for (String plantName : plants.build()) {
            ItemStack plant = PluginHarvestCraft.getItemStack(plantName + "item");
            if (plant == null) continue;
            RecipeUtil.addFermenterRecipes(plant, ForestryAPI.activeMode.getIntegerSetting("fermenter.yield.wheat"), Fluids.BIOMASS);
        }
        for (String cropnutName : cropNuts) {
            ItemStack cropnut = PluginHarvestCraft.getItemStack(cropnutName + "item");
            ItemStack cropnutSeed = PluginHarvestCraft.getItemStack(cropnutName + "seeditem");
            Block cropnutBlock = PluginHarvestCraft.getBlock("pam" + cropnutName + "crop");
            if (cropnutSeed != null) {
                RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{cropnutSeed}, Fluids.SEED_OIL.getFluid(seedamount));
            }
            if (ForestryAPI.enabledPlugins.contains("forestry.farming") && cropnutSeed != null && cropnutBlock != null) {
                Farmables.farmables.get((Object)"farmWheat").add(new FarmableAgingCrop(cropnutSeed, cropnutBlock, (IProperty<Integer>)plantAGE, 3));
                Farmables.farmables.get((Object)"farmOrchard").add(new FarmableAgingCrop(cropnutSeed, cropnutBlock, (IProperty<Integer>)plantAGE, 3, 0));
            }
            if (cropnut == null) continue;
            RecipeManagers.squeezerManager.addRecipe(20, new ItemStack[]{cropnut}, Fluids.SEED_OIL.getFluid(12 * seedamount));
        }
        for (String nutName : nuts) {
            ItemStack nut = PluginHarvestCraft.getItemStack(nutName + "item");
            Block nutBlock = PluginHarvestCraft.getBlock("pam" + nutName);
            if (ForestryAPI.enabledPlugins.contains("forestry.farming") && nutBlock != null) {
                Farmables.farmables.get((Object)"farmOrchard").add(new FarmableAgingCrop(null, nutBlock, (IProperty<Integer>)fruitAGE, 2, 0));
            }
            if (nut == null) continue;
            RecipeManagers.squeezerManager.addRecipe(20, new ItemStack[]{nut}, Fluids.SEED_OIL.getFluid(15 * seedamount));
        }
        ItemStack hcHoneyItem = PluginHarvestCraft.getItemStack("honeyitem");
        if (hcHoneyItem != null) {
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{hcHoneyItem}, Fluids.FOR_HONEY.getFluid(100));
        }
        if ((hcBeeswaxItem = PluginHarvestCraft.getItemStack("beeswaxitem")) != null) {
            RecipeUtil.addRecipe(PluginFluids.items.waxCapsuleEmpty.getItemStack(ForestryAPI.activeMode.getIntegerSetting("recipe.output.capsule")), "XXX ", Character.valueOf('X'), hcBeeswaxItem);
        }
    }
}

