/*
 * Decompiled with CFR 0.152.
 */
package forestry.food.items;

import forestry.api.core.IModelManager;
import forestry.api.food.IBeverageEffect;
import forestry.core.config.Config;
import forestry.core.items.IColoredItem;
import forestry.core.items.ItemForestryFood;
import forestry.core.items.ItemOverlay;
import forestry.food.BeverageEffect;
import forestry.food.items.EnumBeverage;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBeverage
extends ItemForestryFood
implements IColoredItem {
    public final IBeverageInfo[] beverages;

    public ItemBeverage() {
        super(1, 0.2f);
        this.func_77625_d(1);
        this.beverages = EnumBeverage.VALUES;
    }

    public boolean func_77651_p() {
        return true;
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        List<IBeverageEffect> effects = BeverageEffect.loadEffects(stack);
        --stack.field_77994_a;
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entityLiving;
            entityplayer.func_71024_bL().func_151686_a((ItemFood)this, stack);
            worldIn.func_184148_a(null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.5f, worldIn.field_73012_v.nextFloat() * 0.1f + 0.9f);
            if (worldIn.field_72995_K) {
                return stack;
            }
            for (IBeverageEffect effect : effects) {
                effect.doEffect(worldIn, entityplayer);
            }
            entityplayer.func_71029_a(StatList.func_188057_b((Item)this));
        }
        return stack;
    }

    public int func_150905_g(ItemStack itemstack) {
        int meta = itemstack.func_77952_i();
        IBeverageInfo beverage = this.beverages[meta];
        return beverage.getHeal();
    }

    public float func_150906_h(ItemStack itemstack) {
        int meta = itemstack.func_77952_i();
        IBeverageInfo beverage = this.beverages[meta];
        return beverage.getSaturation();
    }

    public int func_77626_a(ItemStack itemstack) {
        return 32;
    }

    @Override
    public EnumAction func_77661_b(ItemStack itemstack) {
        return EnumAction.DRINK;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        int meta = itemStackIn.func_77952_i();
        IBeverageInfo beverage = this.beverages[meta];
        if (playerIn.func_71043_e(beverage.isAlwaysEdible())) {
            playerIn.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)itemStackIn);
    }

    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List<ItemStack> itemList) {
        for (int i = 0; i < this.beverages.length; ++i) {
            if (!Config.isDebug && this.beverages[i].isSecret()) continue;
            itemList.add(new ItemStack((Item)this, 1, i));
        }
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List<String> list, boolean flag) {
        List<IBeverageEffect> effects = BeverageEffect.loadEffects(itemstack);
        for (IBeverageEffect effect : effects) {
            if (effect.getDescription() == null) continue;
            list.add(effect.getDescription());
        }
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + "." + this.beverages[stack.func_77952_i()].getUid();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        for (IBeverageInfo info : this.beverages) {
            info.registerModels(item, manager);
        }
    }

    @Override
    public int getColorFromItemstack(ItemStack itemstack, int j) {
        if (j == 1 || this.beverages[itemstack.func_77952_i()].getSecondaryColor() == 0) {
            return this.beverages[itemstack.func_77952_i()].getPrimaryColor();
        }
        return this.beverages[itemstack.func_77952_i()].getSecondaryColor();
    }

    public ItemStack get(EnumBeverage beverage, int amount) {
        return new ItemStack((Item)this, amount, beverage.ordinal());
    }

    public static interface IBeverageInfo
    extends ItemOverlay.IOverlayInfo {
        public int getHeal();

        public float getSaturation();

        public boolean isAlwaysEdible();

        public void registerModels(Item var1, IModelManager var2);
    }
}

