/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.FarmDirection;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.Log;
import forestry.farming.logic.CropRubber;
import forestry.farming.logic.FarmLogic;
import forestry.plugins.compat.PluginIC2;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FarmLogicRubber
extends FarmLogic {
    private boolean active = true;
    private final Map<BlockPos, Integer> lastExtents = new HashMap<BlockPos, Integer>();

    public FarmLogicRubber() {
        if (PluginIC2.rubberWood == null || PluginIC2.resin == null) {
            Log.warning("Failed to init a farm logic {} since IC2 rubber wood or resin were not found", this.getClass().getName());
            this.active = false;
        }
    }

    @Override
    public ItemStack getIconItemStack() {
        return PluginIC2.resin;
    }

    @Override
    public String getName() {
        return "Rubber Plantation";
    }

    @Override
    public int getFertilizerConsumption() {
        return 40;
    }

    @Override
    public int getWaterConsumption(float hydrationModifier) {
        return (int)(5.0f * hydrationModifier);
    }

    @Override
    public boolean isAcceptedResource(ItemStack itemstack) {
        return false;
    }

    @Override
    public boolean isAcceptedGermling(ItemStack itemstack) {
        return false;
    }

    @Override
    public boolean isAcceptedWindfall(ItemStack stack) {
        return false;
    }

    @Override
    public Collection<ItemStack> collect(World world, IFarmHousing farmHousing) {
        return null;
    }

    @Override
    public boolean cultivate(World world, IFarmHousing farmHousing, BlockPos pos, FarmDirection direction, int extent) {
        return false;
    }

    @Override
    public Collection<ICrop> harvest(World world, BlockPos pos, FarmDirection direction, int extent) {
        int lastExtent;
        if (!this.active) {
            return null;
        }
        if (!this.lastExtents.containsKey(pos)) {
            this.lastExtents.put(pos, 0);
        }
        if ((lastExtent = this.lastExtents.get(pos).intValue()) > extent) {
            lastExtent = 0;
        }
        BlockPos position = this.translateWithOffset(pos.func_177984_a(), direction, lastExtent);
        Collection<ICrop> crops = this.getHarvestBlocks(world, position);
        this.lastExtents.put(pos, ++lastExtent);
        return crops;
    }

    private Collection<ICrop> getHarvestBlocks(World world, BlockPos position) {
        BlockPos candidate;
        IBlockState blockState;
        Block block;
        Stack<ICrop> crops = new Stack<ICrop>();
        for (int j = 0; j < 10 && ItemStackUtil.equals(block = (blockState = world.func_180495_p(candidate = position.func_177982_a(0, j, 0))).func_177230_c(), PluginIC2.rubberWood); ++j) {
            if (!CropRubber.hasRubberToHarvest(blockState)) continue;
            crops.push(new CropRubber(world, blockState, candidate));
            break;
        }
        return crops;
    }
}

