/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.FarmDirection;
import forestry.api.farming.Farmables;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmable;
import forestry.farming.logic.FarmLogic;
import java.util.Collection;
import java.util.Stack;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FarmLogicGourd
extends FarmLogic {
    private final IFarmable[] seeds;

    public FarmLogicGourd() {
        Collection farmables = Farmables.farmables.get((Object)"farmGourd");
        this.seeds = farmables.toArray(new IFarmable[farmables.size()]);
    }

    @Override
    public ItemStack getIconItemStack() {
        return new ItemStack(Items.field_151127_ba);
    }

    @Override
    public String getName() {
        return "Gourd Farm";
    }

    @Override
    public int getFertilizerConsumption() {
        return 10;
    }

    @Override
    public int getWaterConsumption(float hydrationModifier) {
        return (int)(40.0f * hydrationModifier);
    }

    @Override
    public boolean isAcceptedResource(ItemStack itemstack) {
        return false;
    }

    @Override
    public boolean isAcceptedGermling(ItemStack itemstack) {
        return false;
    }

    @Override
    public boolean isAcceptedWindfall(ItemStack stack) {
        return false;
    }

    @Override
    public Collection<ItemStack> collect(World world, IFarmHousing farmHousing) {
        return null;
    }

    @Override
    public boolean cultivate(World world, IFarmHousing farmHousing, BlockPos pos, FarmDirection direction, int extent) {
        return false;
    }

    @Override
    public Collection<ICrop> harvest(World world, BlockPos pos, FarmDirection direction, int extent) {
        Stack<ICrop> crops = new Stack<ICrop>();
        block0: for (int i = 0; i < extent; ++i) {
            BlockPos position = this.translateWithOffset(pos.func_177984_a(), direction, i);
            IBlockState blockState = world.func_180495_p(position);
            for (IFarmable seed : this.seeds) {
                ICrop crop = seed.getCropAt(world, position, blockState);
                if (crop == null) continue;
                crops.push(crop);
                continue block0;
            }
        }
        return crops;
    }
}

