/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.inventory;

import forestry.api.fuels.FuelManager;
import forestry.core.fluids.FluidHelper;
import forestry.core.inventory.InventoryAdapterTile;
import forestry.factory.recipes.FermenterRecipeManager;
import forestry.factory.tiles.TileFermenter;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class InventoryFermenter
extends InventoryAdapterTile<TileFermenter> {
    public static final short SLOT_RESOURCE = 0;
    public static final short SLOT_FUEL = 1;
    public static final short SLOT_CAN_OUTPUT = 2;
    public static final short SLOT_CAN_INPUT = 3;
    public static final short SLOT_INPUT = 4;

    public InventoryFermenter(TileFermenter fermenter) {
        super(fermenter, 5, "Items");
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        if (slotIndex == 0) {
            return FermenterRecipeManager.isResource(itemStack);
        }
        if (slotIndex == 4) {
            FluidStack fluid = FluidUtil.getFluidContained((ItemStack)itemStack);
            return ((TileFermenter)this.tile).getTankManager().canFillFluidType(fluid);
        }
        if (slotIndex == 3) {
            return FluidHelper.isFillableContainerWithRoom(itemStack);
        }
        if (slotIndex == 1) {
            return FuelManager.fermenterFuel.containsKey(itemStack);
        }
        return false;
    }

    @Override
    public boolean func_180461_b(int slotIndex, ItemStack itemstack, EnumFacing side) {
        return slotIndex == 2;
    }
}

