/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network.packets;

import forestry.core.fluids.ITankManager;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.PacketIdClient;
import forestry.core.network.packets.PacketCoordinates;
import forestry.core.proxy.Proxies;
import forestry.core.tiles.ILiquidTankTile;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;

public class PacketTankLevelUpdate
extends PacketCoordinates
implements IForestryPacketClient {
    private int tankIndex;
    private FluidStack contents;

    public PacketTankLevelUpdate() {
    }

    public PacketTankLevelUpdate(ILiquidTankTile tileEntity, int tankIndex, FluidStack contents) {
        super(tileEntity.getCoordinates());
        this.tankIndex = tankIndex;
        this.contents = contents;
    }

    @Override
    protected void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        data.writeVarInt(this.tankIndex);
        data.writeFluidStack(this.contents);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.tankIndex = data.readVarInt();
        this.contents = data.readFluidStack();
    }

    @Override
    public void onPacketData(DataInputStreamForestry data, EntityPlayer player) throws IOException {
        TileEntity tileEntity = this.getTarget(Proxies.common.getRenderWorld());
        if (tileEntity instanceof ILiquidTankTile) {
            ITankManager tankManager = ((ILiquidTankTile)tileEntity).getTankManager();
            tankManager.processTankUpdate(this.tankIndex, this.contents);
        }
    }

    @Override
    public PacketIdClient getPacketId() {
        return PacketIdClient.TANK_LEVEL_UPDATE;
    }
}

