/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.models;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.client.model.pipeline.VertexTransformer;
import net.minecraftforge.common.model.TRSRTransformation;

public class TRSRBakedModel
implements IBakedModel {
    protected final ImmutableList<BakedQuad> general;
    protected final ImmutableMap<EnumFacing, ImmutableList<BakedQuad>> faces;
    protected final IBakedModel original;

    public TRSRBakedModel(IBakedModel original, float x, float y, float z, float scale) {
        this(original, x, y, z, 0.0f, 0.0f, 0.0f, scale, scale, scale);
    }

    public TRSRBakedModel(IBakedModel original, float x, float y, float z, float rotX, float rotY, float rotZ, float scale) {
        this(original, x, y, z, rotX, rotY, rotZ, scale, scale, scale);
    }

    public TRSRBakedModel(IBakedModel original, float x, float y, float z, float rotX, float rotY, float rotZ, float scaleX, float scaleY, float scaleZ) {
        this(original, new TRSRTransformation(new Vector3f(x, y, z), null, new Vector3f(scaleX, scaleY, scaleZ), TRSRTransformation.quatFromYXZ((float)rotY, (float)rotX, (float)rotZ)));
    }

    public TRSRBakedModel(IBakedModel original, TRSRTransformation transform) {
        this.original = original;
        ImmutableList.Builder builder = ImmutableList.builder();
        transform = TRSRTransformation.blockCenterToCorner((TRSRTransformation)transform);
        EnumMap faces = Maps.newEnumMap(EnumFacing.class);
        for (EnumFacing face : EnumFacing.values()) {
            if (!original.func_188618_c()) {
                for (BakedQuad quad : original.func_188616_a(null, face, 0L)) {
                    Transformer transformer = new Transformer(transform, quad.getFormat());
                    quad.pipe((IVertexConsumer)transformer);
                    builder.add((Object)transformer.build());
                }
            }
            faces.put(face, ImmutableList.of());
        }
        if (!original.func_188618_c()) {
            for (BakedQuad quad : original.func_188616_a(null, null, 0L)) {
                Transformer transformer = new Transformer(transform, quad.getFormat());
                quad.pipe((IVertexConsumer)transformer);
                builder.add((Object)transformer.build());
            }
        }
        this.general = builder.build();
        this.faces = Maps.immutableEnumMap((Map)faces);
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        if (side != null) {
            return (List)this.faces.get((Object)side);
        }
        return this.general;
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return this.original.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.original.func_188618_c();
    }

    public TextureAtlasSprite func_177554_e() {
        return this.original.func_177554_e();
    }

    public ItemCameraTransforms func_177552_f() {
        return this.original.func_177552_f();
    }

    public ItemOverrideList func_188617_f() {
        return null;
    }

    public static class Transformer
    extends VertexTransformer {
        protected Matrix4f transformation;
        protected Matrix3f normalTransformation;

        public Transformer(TRSRTransformation transformation, VertexFormat format) {
            super((IVertexConsumer)new UnpackedBakedQuad.Builder(format));
            this.transformation = transformation.getMatrix();
            this.normalTransformation = new Matrix3f();
            this.transformation.getRotationScale(this.normalTransformation);
            this.normalTransformation.invert();
            this.normalTransformation.transpose();
        }

        public void put(int element, float ... data) {
            VertexFormatElement.EnumUsage usage = this.parent.getVertexFormat().func_177348_c(element).func_177375_c();
            if (usage == VertexFormatElement.EnumUsage.POSITION && data.length >= 3) {
                Vector4f vec = new Vector4f(data);
                vec.setW(1.0f);
                this.transformation.transform((Tuple4f)vec);
                data = new float[4];
                vec.get(data);
            } else if (usage == VertexFormatElement.EnumUsage.NORMAL && data.length >= 3) {
                Vector3f vec = new Vector3f(data);
                this.normalTransformation.transform((Tuple3f)vec);
                vec.normalize();
                data = new float[4];
                vec.get(data);
            }
            super.put(element, data);
        }

        public UnpackedBakedQuad build() {
            return ((UnpackedBakedQuad.Builder)this.parent).build();
        }
    }
}

