/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.items;

import forestry.api.core.IModelManager;
import forestry.core.config.Config;
import forestry.core.items.IColoredItem;
import forestry.core.items.ItemForestry;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemOverlay
extends ItemForestry
implements IColoredItem {
    protected final IOverlayInfo[] overlays;

    public ItemOverlay(CreativeTabs tab, IOverlayInfo[] overlays) {
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77637_a(tab);
        this.overlays = overlays;
    }

    public boolean func_77645_m() {
        return false;
    }

    public boolean isRepairable() {
        return false;
    }

    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List<ItemStack> itemList) {
        for (int i = 0; i < this.overlays.length; ++i) {
            if (!Config.isDebug && this.overlays[i].isSecret()) continue;
            itemList.add(new ItemStack((Item)this, 1, i));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        for (int i = 0; i < this.overlays.length; ++i) {
            manager.registerItemModel(item, i);
        }
    }

    public String func_77667_c(ItemStack stack) {
        if (stack.func_77952_i() < 0 || stack.func_77952_i() >= this.overlays.length) {
            return null;
        }
        return super.func_77667_c(stack) + "." + this.overlays[stack.func_77952_i()].getUid();
    }

    @Override
    public int getColorFromItemstack(ItemStack stack, int tintIndex) {
        int meta = stack.func_77960_j();
        if (meta < 0 || meta >= this.overlays.length) {
            return 0xFFFFFF;
        }
        IOverlayInfo overlayInfo = this.overlays[meta];
        if (tintIndex == 0 || overlayInfo.getSecondaryColor() == 0) {
            return overlayInfo.getPrimaryColor();
        }
        return overlayInfo.getSecondaryColor();
    }

    public static interface IOverlayInfo {
        public String getUid();

        public int getPrimaryColor();

        public int getSecondaryColor();

        public boolean isSecret();
    }
}

