/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.items;

import forestry.api.core.IModelManager;
import forestry.core.items.IColoredItem;
import forestry.core.items.ItemForestry;
import forestry.core.proxy.Proxies;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.Translator;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCrated
extends ItemForestry
implements IColoredItem {
    @Nullable
    private final ItemStack contained;
    @Nullable
    private final String oreDictName;

    public ItemCrated(@Nullable ItemStack contained, @Nullable String oreDictName) {
        this.contained = contained;
        this.oreDictName = oreDictName;
    }

    @Nullable
    public ItemStack getContained() {
        return this.contained;
    }

    @Nullable
    public String getOreDictName() {
        return this.oreDictName;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (!worldIn.field_72995_K) {
            if (this.contained == null || itemStackIn.field_77994_a == 0) {
                return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemStackIn);
            }
            --itemStackIn.field_77994_a;
            ItemStack dropStack = this.contained.func_77946_l();
            dropStack.field_77994_a = 9;
            ItemStackUtil.dropItemStackAsEntity(dropStack, worldIn, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, 40);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStackIn);
    }

    public String func_77653_i(ItemStack itemstack) {
        if (this.contained == null) {
            return Translator.translateToLocal("item.for.crate.name");
        }
        String containedName = Proxies.common.getDisplayName(this.contained);
        return Translator.translateToLocalFormatted("for.item.crated.grammar", containedName);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        if (this.contained == null) {
            manager.registerItemModel(item, 0);
            manager.registerItemModel(item, 1, "crate-filled");
        } else {
            ModelResourceLocation modelLocation = new ModelResourceLocation("forestry:crate-filled", "crate-filled");
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)modelLocation);
            ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{modelLocation});
        }
    }

    @Override
    public int getColorFromItemstack(ItemStack stack, int renderPass) {
        ItemColors colors = Proxies.common.getClientInstance().getItemColors();
        if (this.getContained() == null || renderPass == 100) {
            return -1;
        }
        int color = colors.func_186728_a(this.contained, renderPass);
        if (color != -1) {
            return color;
        }
        return -1;
    }

    @Nullable
    public String getUID() {
        ResourceLocation registryName = this.getRegistryName();
        if (registryName != null) {
            return registryName.func_110623_a();
        }
        return null;
    }
}

