/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.tooltips;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.text.TextFormatting;

public class ToolTip {
    private final List<String> lines = new ArrayList<String>();
    private final long delay;
    private long mouseOverStart;

    public ToolTip() {
        this.delay = 0L;
    }

    public ToolTip(int delay) {
        this.delay = delay;
    }

    public void clear() {
        this.lines.clear();
    }

    public boolean add(@Nonnull String line) {
        return this.add(line, null);
    }

    public boolean add(@Nonnull String line, @Nullable TextFormatting formatting) {
        if (formatting != null) {
            return this.lines.add(formatting + line);
        }
        return this.lines.add(line);
    }

    public boolean add(List lines) {
        boolean changed = false;
        for (Object line : lines) {
            if (!(line instanceof String)) continue;
            changed |= this.add((String)line);
        }
        return changed;
    }

    public List<String> getLines() {
        return Collections.unmodifiableList(this.lines);
    }

    public void onTick(boolean mouseOver) {
        if (this.delay == 0L) {
            return;
        }
        if (mouseOver) {
            if (this.mouseOverStart == 0L) {
                this.mouseOverStart = System.currentTimeMillis();
            }
        } else {
            this.mouseOverStart = 0L;
        }
    }

    public boolean isReady() {
        if (this.delay == 0L) {
            return true;
        }
        if (this.mouseOverStart == 0L) {
            return false;
        }
        return System.currentTimeMillis() - this.mouseOverStart >= this.delay;
    }

    public void refresh() {
    }
}

