/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.blocks;

import forestry.core.proxy.Proxies;
import forestry.plugins.PluginManager;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.oredict.OreDictionary;

public abstract class BlockRegistry {
    protected <T extends Block> void registerBlock(T block, ItemBlock itemBlock, String name) {
        if (PluginManager.getStage() != PluginManager.Stage.REGISTER) {
            throw new RuntimeException("Tried to register Block outside of REGISTER");
        }
        block.func_149663_c("for." + name);
        block.setRegistryName(name);
        GameRegistry.register(block);
        Proxies.common.registerBlock(block);
        if (itemBlock != null) {
            itemBlock.setRegistryName(name);
            GameRegistry.register((IForgeRegistryEntry)itemBlock);
            Proxies.common.registerItem((Item)itemBlock);
        }
    }

    protected <T extends Block> void registerBlock(T block, String name) {
        this.registerBlock(block, null, name);
    }

    protected static void registerOreDictWildcard(String oreDictName, Block block) {
        OreDictionary.registerOre((String)oreDictName, (ItemStack)new ItemStack(block, 1, Short.MAX_VALUE));
    }
}

