/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.TreeBlockTypeLeaf;
import forestry.arboriculture.worldgen.TreeBlockTypeLog;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.worldgen.WorldGenHelper;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldGenAcacia
extends WorldGenTree {
    public WorldGenAcacia(ITreeGenData tree) {
        super(tree, 5, 2);
    }

    @Override
    @Nonnull
    public Set<BlockPos> generateTrunk(World world, Random rand, TreeBlockTypeLog wood, BlockPos startPos) {
        WorldGenHelper.Direction leanDirection = WorldGenHelper.Direction.getRandom(rand);
        float leanAmount = (float)this.height / 4.0f;
        Set<BlockPos> treeTops = WorldGenHelper.generateTreeTrunk(world, rand, wood, startPos, this.height, this.girth, 0, 0.0f, leanDirection.facing, leanAmount);
        if (this.height > 5 && rand.nextBoolean()) {
            WorldGenHelper.Direction branchDirection = WorldGenHelper.Direction.getRandomOther(rand, leanDirection);
            Set<BlockPos> treeTops2 = WorldGenHelper.generateTreeTrunk(world, rand, wood, startPos, Math.round((float)this.height * 0.66f), this.girth, 0, 0.0f, branchDirection.facing, leanAmount);
            treeTops.addAll(treeTops2);
        }
        HashSet<BlockPos> branchEnds = new HashSet<BlockPos>();
        for (BlockPos treeTop : treeTops) {
            int xOffset = treeTop.func_177958_n();
            int yOffset = treeTop.func_177956_o() - startPos.func_177956_o() + 1;
            int zOffset = treeTop.func_177952_p();
            float canopyMultiplier = (1.5f * (float)this.height - (float)yOffset + 2.0f) / 4.0f;
            int canopyThickness = Math.max(1, Math.round((float)yOffset / 10.0f));
            branchEnds.add(new BlockPos(xOffset, startPos.func_177956_o() + yOffset--, zOffset));
            float canopyWidth = rand.nextBoolean() ? 3.0f : 2.5f;
            int radius = Math.round(canopyMultiplier * canopyWidth - 4.0f);
            BlockPos pos = new BlockPos(xOffset, startPos.func_177956_o() + --yOffset - canopyThickness, zOffset);
            branchEnds.addAll(WorldGenHelper.generateBranches(world, rand, wood, pos, this.girth, 0.0f, 0.1f, radius, 2, 1.0f));
        }
        return branchEnds;
    }

    @Override
    protected void generateLeaves(World world, Random rand, TreeBlockTypeLeaf leaf, List<BlockPos> branchEnds, BlockPos startPos) {
        for (BlockPos branchEnd : branchEnds) {
            int leafSpawn = branchEnd.func_177956_o() - startPos.func_177956_o();
            int canopyThickness = Math.max(1, Math.round((float)leafSpawn / 10.0f));
            float canopyMultiplier = (1.5f * (float)this.height - (float)leafSpawn + 2.0f) / 4.0f;
            float canopyWidth = rand.nextBoolean() ? 1.0f : 1.5f;
            BlockPos center = new BlockPos(branchEnd.func_177958_n(), leafSpawn - canopyThickness + 1 + startPos.func_177956_o(), branchEnd.func_177952_p());
            float radius = Math.max(1.0f, canopyMultiplier * canopyWidth + (float)this.girth);
            WorldGenHelper.generateCylinderFromPos(world, leaf, center, radius, canopyThickness, WorldGenHelper.EnumReplaceMode.AIR);
        }
    }
}

