/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.render;

import forestry.api.arboriculture.EnumPileType;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.TreeManager;
import forestry.arboriculture.blocks.BlockPile;
import forestry.arboriculture.multiblock.EnumPilePosition;
import forestry.arboriculture.multiblock.ICharcoalPileControllerInternal;
import forestry.arboriculture.tiles.TilePile;
import forestry.core.multiblock.MultiblockLogic;
import forestry.core.proxy.Proxies;
import forestry.core.render.TextureManager;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;

public class CharcoalPileRenderer
extends TileEntitySpecialRenderer<TilePile> {
    public void renderTileEntityAt(@Nonnull TilePile pile, double x, double y, double z, float p_147500_8_, int destroyStage) {
        IBlockState state = pile.func_145831_w().func_180495_p(pile.func_174877_v());
        if (!(state.func_177230_c() instanceof BlockPile)) {
            return;
        }
        EnumPilePosition pilePosition = (EnumPilePosition)((Object)state.func_177229_b(BlockPile.PILE_POSITION));
        MultiblockLogic logic = (MultiblockLogic)pile.getMultiblockLogic();
        if (pilePosition != EnumPilePosition.INTERIOR && logic.isConnected() && logic.getController() != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
            GlStateManager.func_179094_E();
            GlStateManager.func_179140_f();
            Proxies.common.getClientInstance().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            boolean withWood = pile.getPileType() != EnumPileType.ASH;
            boolean isOnTop = ((ICharcoalPileControllerInternal)logic.getController()).getMaximumCoord().func_177956_o() == pile.func_174877_v().func_177956_o();
            int brightness = state.func_185889_a((IBlockAccess)pile.func_145831_w(), pile.func_174877_v());
            IAlleleTreeSpecies treeSpecies = pile.getNextWoodPile();
            if (treeSpecies == null) {
                treeSpecies = (IAlleleTreeSpecies)TreeManager.treeRoot.getDefaultTemplate()[TreeManager.treeRoot.getSpeciesChromosomeType().ordinal()];
            }
            TextureAtlasSprite dirtSprite = pile.getPileType() == EnumPileType.ASH ? TextureManager.registerSprite(new ResourceLocation("forestry:blocks/ash")) : TextureManager.registerSprite(new ResourceLocation("forestry:blocks/loam"));
            TextureAtlasSprite woodSprite = treeSpecies.getWoodProvider().getSprite(false);
            TextureAtlasSprite woodTopSprite = treeSpecies.getWoodProvider().getSprite(true);
            if (pilePosition == EnumPilePosition.BACK) {
                CharcoalPileRenderer.renderPileSide(withWood, dirtSprite, woodSprite, woodTopSprite, brightness);
            } else if (pilePosition == EnumPilePosition.FRONT) {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                CharcoalPileRenderer.renderPileSide(withWood, dirtSprite, woodSprite, woodTopSprite, brightness);
            } else if (pilePosition == EnumPilePosition.SIDE_LEFT) {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                CharcoalPileRenderer.renderPileSide(withWood, dirtSprite, woodSprite, woodTopSprite, brightness);
            } else if (pilePosition == EnumPilePosition.SIDE_RIGHT) {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                CharcoalPileRenderer.renderPileSide(withWood, dirtSprite, woodSprite, woodTopSprite, brightness);
            } else if (pilePosition == EnumPilePosition.CORNER_BACK_RIGHT) {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                CharcoalPileRenderer.renderPileCorner(withWood, dirtSprite, woodSprite, woodTopSprite, brightness, isOnTop);
            } else if (pilePosition == EnumPilePosition.CORNER_BACK_LEFT) {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                CharcoalPileRenderer.renderPileCorner(withWood, dirtSprite, woodSprite, woodTopSprite, brightness, isOnTop);
            } else if (pilePosition == EnumPilePosition.CORNER_FRONT_LEFT) {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                CharcoalPileRenderer.renderPileCorner(withWood, dirtSprite, woodSprite, woodTopSprite, brightness, isOnTop);
            } else if (pilePosition == EnumPilePosition.CORNER_FRONT_RIGHT) {
                GlStateManager.func_179114_b((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                CharcoalPileRenderer.renderPileCorner(withWood, dirtSprite, woodSprite, woodTopSprite, brightness, isOnTop);
            }
            GlStateManager.func_179145_e();
            GlStateManager.func_179121_F();
            GlStateManager.func_179121_F();
        }
    }

    public static void renderPileSide(boolean withWood, TextureAtlasSprite dirtSprite, TextureAtlasSprite woodSprite, TextureAtlasSprite woodTopSprite, int brightness) {
        Tessellator t = Tessellator.func_178181_a();
        VertexBuffer buffer = t.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b(-0.5, -0.5, -0.5).func_187315_a((double)dirtSprite.func_94209_e(), (double)dirtSprite.func_94206_g()).func_181675_d();
        buffer.func_181662_b(0.5, -0.5, -0.5).func_187315_a((double)dirtSprite.func_94212_f(), (double)dirtSprite.func_94206_g()).func_181675_d();
        buffer.func_181662_b(0.5, -0.5, 0.5).func_187315_a((double)dirtSprite.func_94212_f(), (double)dirtSprite.func_94210_h()).func_181675_d();
        buffer.func_181662_b(-0.5, -0.5, 0.5).func_187315_a((double)dirtSprite.func_94209_e(), (double)dirtSprite.func_94210_h()).func_181675_d();
        buffer.func_181662_b(0.5, -0.5, -0.5).func_187315_a((double)dirtSprite.func_94209_e(), (double)dirtSprite.func_94210_h()).func_181675_d();
        buffer.func_181662_b(-0.5, -0.5, -0.5).func_187315_a((double)dirtSprite.func_94212_f(), (double)dirtSprite.func_94210_h()).func_181675_d();
        buffer.func_181662_b(-0.5, 0.5, 0.5).func_187315_a((double)dirtSprite.func_94212_f(), (double)dirtSprite.func_94206_g()).func_181675_d();
        buffer.func_181662_b(0.5, 0.5, 0.5).func_187315_a((double)dirtSprite.func_94209_e(), (double)dirtSprite.func_94206_g()).func_181675_d();
        buffer.func_181662_b(-0.5, 0.5, 0.5).func_187315_a((double)dirtSprite.func_94209_e(), (double)dirtSprite.func_94206_g()).func_181675_d();
        buffer.func_181662_b(-0.5, -0.5, 0.5).func_187315_a((double)dirtSprite.func_94212_f(), (double)dirtSprite.func_94206_g()).func_181675_d();
        buffer.func_181662_b(0.5, -0.5, 0.5).func_187315_a((double)dirtSprite.func_94212_f(), (double)dirtSprite.func_94210_h()).func_181675_d();
        buffer.func_181662_b(0.5, 0.5, 0.5).func_187315_a((double)dirtSprite.func_94209_e(), (double)dirtSprite.func_94210_h()).func_181675_d();
        buffer.func_181662_b(-0.5, -0.5, -0.5).func_187315_a((double)dirtSprite.func_94209_e(), (double)dirtSprite.func_94206_g()).func_181675_d();
        buffer.func_181662_b(-0.5, -0.5, -0.5).func_187315_a((double)dirtSprite.func_94212_f(), (double)dirtSprite.func_94206_g()).func_181675_d();
        buffer.func_181662_b(-0.5, -0.5, 0.5).func_187315_a((double)dirtSprite.func_94212_f(), (double)dirtSprite.func_94210_h()).func_181675_d();
        buffer.func_181662_b(-0.5, 0.5, 0.5).func_187315_a((double)dirtSprite.func_94209_e(), (double)dirtSprite.func_94210_h()).func_181675_d();
        buffer.func_181662_b(0.5, 0.5, 0.5).func_187315_a((double)dirtSprite.func_94209_e(), (double)dirtSprite.func_94206_g()).func_181675_d();
        buffer.func_181662_b(0.5, -0.5, 0.5).func_187315_a((double)dirtSprite.func_94212_f(), (double)dirtSprite.func_94206_g()).func_181675_d();
        buffer.func_181662_b(0.5, -0.5, -0.5).func_187315_a((double)dirtSprite.func_94209_e(), (double)dirtSprite.func_94210_h()).func_181675_d();
        buffer.func_181662_b(0.5, -0.5, -0.5).func_187315_a((double)dirtSprite.func_94212_f(), (double)dirtSprite.func_94210_h()).func_181675_d();
        if (withWood) {
            buffer.func_181662_b(0.1, 0.3, 0.3).func_187315_a((double)woodSprite.func_94212_f(), (double)woodSprite.func_94210_h()).func_181675_d();
            buffer.func_181662_b(0.1, -0.5, -0.5).func_187315_a((double)woodSprite.func_94212_f(), (double)woodSprite.func_94206_g()).func_181675_d();
            buffer.func_181662_b(0.1, -0.5, -0.7).func_187315_a((double)woodSprite.func_94209_e(), (double)woodSprite.func_94206_g()).func_181675_d();
            buffer.func_181662_b(0.1, 0.5, 0.3).func_187315_a((double)woodSprite.func_94209_e(), (double)woodSprite.func_94210_h()).func_181675_d();
            buffer.func_181662_b(0.1, 0.5, 0.3).func_187315_a((double)woodSprite.func_94212_f(), (double)woodSprite.func_94210_h()).func_181675_d();
            buffer.func_181662_b(0.1, -0.5, -0.7).func_187315_a((double)woodSprite.func_94212_f(), (double)woodSprite.func_94206_g()).func_181675_d();
            buffer.func_181662_b(-0.1, -0.5, -0.7).func_187315_a((double)woodSprite.func_94209_e(), (double)woodSprite.func_94206_g()).func_181675_d();
            buffer.func_181662_b(-0.1, 0.5, 0.3).func_187315_a((double)woodSprite.func_94209_e(), (double)woodSprite.func_94210_h()).func_181675_d();
            buffer.func_181662_b(-0.1, 0.5, 0.3).func_187315_a((double)woodSprite.func_94212_f(), (double)woodSprite.func_94210_h()).func_181675_d();
            buffer.func_181662_b(-0.1, -0.5, -0.7).func_187315_a((double)woodSprite.func_94212_f(), (double)woodSprite.func_94206_g()).func_181675_d();
            buffer.func_181662_b(-0.1, -0.5, -0.5).func_187315_a((double)woodSprite.func_94209_e(), (double)woodSprite.func_94206_g()).func_181675_d();
            buffer.func_181662_b(-0.1, 0.3, 0.3).func_187315_a((double)woodSprite.func_94209_e(), (double)woodSprite.func_94210_h()).func_181675_d();
            buffer.func_181662_b(-0.1, -0.5, -0.7).func_187315_a((double)woodTopSprite.func_94209_e(), (double)woodTopSprite.func_94206_g()).func_181675_d();
            buffer.func_181662_b(0.1, -0.5, -0.7).func_187315_a((double)woodTopSprite.func_94212_f(), (double)woodTopSprite.func_94206_g()).func_181675_d();
            buffer.func_181662_b(0.1, -0.5, -0.5).func_187315_a((double)woodTopSprite.func_94212_f(), (double)woodTopSprite.func_94210_h()).func_181675_d();
            buffer.func_181662_b(-0.1, -0.5, -0.5).func_187315_a((double)woodTopSprite.func_94209_e(), (double)woodTopSprite.func_94210_h()).func_181675_d();
            buffer.func_181662_b(-0.5, 0.3, 0.5).func_187315_a((double)woodSprite.func_94209_e(), (double)woodSprite.func_94206_g()).func_181675_d();
            buffer.func_181662_b(-0.5, 0.3, 0.3).func_187315_a((double)woodSprite.func_94212_f(), (double)woodSprite.func_94206_g()).func_181675_d();
            buffer.func_181662_b(0.5, 0.3, 0.3).func_187315_a((double)woodSprite.func_94212_f(), (double)woodSprite.func_94210_h()).func_181675_d();
            buffer.func_181662_b(0.5, 0.3, 0.5).func_187315_a((double)woodSprite.func_94209_e(), (double)woodSprite.func_94210_h()).func_181675_d();
            buffer.func_181662_b(-0.5, 0.5, 0.5).func_187315_a((double)woodSprite.func_94209_e(), (double)woodSprite.func_94206_g()).func_181675_d();
            buffer.func_181662_b(0.5, 0.5, 0.5).func_187315_a((double)woodSprite.func_94212_f(), (double)woodSprite.func_94206_g()).func_181675_d();
            buffer.func_181662_b(0.5, 0.5, 0.3).func_187315_a((double)woodSprite.func_94212_f(), (double)woodSprite.func_94210_h()).func_181675_d();
            buffer.func_181662_b(-0.5, 0.5, 0.3).func_187315_a((double)woodSprite.func_94209_e(), (double)woodSprite.func_94210_h()).func_181675_d();
            buffer.func_181662_b(0.5, 0.5, 0.3).func_187315_a((double)woodSprite.func_94209_e(), (double)woodSprite.func_94206_g()).func_181675_d();
            buffer.func_181662_b(0.5, 0.3, 0.3).func_187315_a((double)woodSprite.func_94212_f(), (double)woodSprite.func_94206_g()).func_181675_d();
            buffer.func_181662_b(-0.5, 0.3, 0.3).func_187315_a((double)woodSprite.func_94212_f(), (double)woodSprite.func_94210_h()).func_181675_d();
            buffer.func_181662_b(-0.5, 0.5, 0.3).func_187315_a((double)woodSprite.func_94209_e(), (double)woodSprite.func_94210_h()).func_181675_d();
        }
        t.func_78381_a();
    }

    public static void renderPileCorner(boolean withWood, TextureAtlasSprite dirtSprite, TextureAtlasSprite woodSprite, TextureAtlasSprite woodTopSprite, int brightness, boolean isTop) {
        Tessellator t = Tessellator.func_178181_a();
        VertexBuffer buffer = t.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b(-0.5, -0.5, -0.5).func_187315_a((double)dirtSprite.func_94209_e(), (double)dirtSprite.func_94206_g()).func_181675_d();
        buffer.func_181662_b(0.5, -0.5, -0.5).func_187315_a((double)dirtSprite.func_94212_f(), (double)dirtSprite.func_94206_g()).func_181675_d();
        buffer.func_181662_b(0.5, -0.5, 0.5).func_187315_a((double)dirtSprite.func_94212_f(), (double)dirtSprite.func_94210_h()).func_181675_d();
        buffer.func_181662_b(-0.5, -0.5, 0.5).func_187315_a((double)dirtSprite.func_94209_e(), (double)dirtSprite.func_94210_h()).func_181675_d();
        buffer.func_181662_b(0.5, -0.5, 0.5).func_187315_a((double)dirtSprite.func_94209_e(), (double)dirtSprite.func_94210_h()).func_181675_d();
        buffer.func_181662_b(0.5, -0.5, -0.5).func_187315_a((double)dirtSprite.func_94212_f(), (double)dirtSprite.func_94210_h()).func_181675_d();
        buffer.func_181662_b(-0.5, 0.5, 0.5).func_187315_a((double)dirtSprite.func_94212_f(), (double)dirtSprite.func_94206_g()).func_181675_d();
        buffer.func_181662_b(-0.5, 0.5, 0.5).func_187315_a((double)dirtSprite.func_94209_e(), (double)dirtSprite.func_94206_g()).func_181675_d();
        buffer.func_181662_b(-0.5, 0.5, 0.5).func_187315_a((double)dirtSprite.func_94212_f(), (double)dirtSprite.func_94206_g()).func_181675_d();
        buffer.func_181662_b(0.5, -0.5, -0.5).func_187315_a((double)dirtSprite.func_94212_f(), (double)dirtSprite.func_94210_h()).func_181675_d();
        buffer.func_181662_b(-0.5, -0.5, -0.5).func_187315_a((double)dirtSprite.func_94209_e(), (double)dirtSprite.func_94210_h()).func_181675_d();
        buffer.func_181662_b(-0.5, 0.5, 0.5).func_187315_a((double)dirtSprite.func_94209_e(), (double)dirtSprite.func_94206_g()).func_181675_d();
        buffer.func_181662_b(-0.5, -0.5, -0.5).func_187315_a((double)dirtSprite.func_94209_e(), (double)dirtSprite.func_94206_g()).func_181675_d();
        buffer.func_181662_b(-0.5, -0.5, -0.5).func_187315_a((double)dirtSprite.func_94212_f(), (double)dirtSprite.func_94206_g()).func_181675_d();
        buffer.func_181662_b(-0.5, -0.5, 0.5).func_187315_a((double)dirtSprite.func_94212_f(), (double)dirtSprite.func_94210_h()).func_181675_d();
        buffer.func_181662_b(-0.5, 0.5, 0.5).func_187315_a((double)dirtSprite.func_94209_e(), (double)dirtSprite.func_94210_h()).func_181675_d();
        buffer.func_181662_b(-0.5, 0.5, 0.5).func_187315_a((double)dirtSprite.func_94209_e(), (double)dirtSprite.func_94206_g()).func_181675_d();
        buffer.func_181662_b(-0.5, -0.5, 0.5).func_187315_a((double)dirtSprite.func_94212_f(), (double)dirtSprite.func_94206_g()).func_181675_d();
        buffer.func_181662_b(0.5, -0.5, 0.5).func_187315_a((double)dirtSprite.func_94209_e(), (double)dirtSprite.func_94210_h()).func_181675_d();
        buffer.func_181662_b(0.5, -0.5, 0.5).func_187315_a((double)dirtSprite.func_94212_f(), (double)dirtSprite.func_94210_h()).func_181675_d();
        if (isTop && withWood) {
            buffer.func_181662_b(-0.3, 0.3, 0.3).func_187315_a((double)woodSprite.func_94212_f(), (double)woodSprite.func_94210_h()).func_181675_d();
            buffer.func_181662_b(-0.3, -0.5, -0.5).func_187315_a((double)woodSprite.func_94212_f(), (double)woodSprite.func_94206_g()).func_181675_d();
            buffer.func_181662_b(-0.3, -0.5, -0.7).func_187315_a((double)woodSprite.func_94209_e(), (double)woodSprite.func_94206_g()).func_181675_d();
            buffer.func_181662_b(-0.3, 0.5, 0.3).func_187315_a((double)woodSprite.func_94209_e(), (double)woodSprite.func_94210_h()).func_181675_d();
            buffer.func_181662_b(-0.3, 0.5, 0.3).func_187315_a((double)woodSprite.func_94209_e(), (double)woodSprite.func_94206_g()).func_181675_d();
            buffer.func_181662_b(-0.3, -0.5, -0.7).func_187315_a((double)woodSprite.func_94209_e(), (double)woodSprite.func_94210_h()).func_181675_d();
            buffer.func_181662_b(-0.5, -0.5, -0.7).func_187315_a((double)woodSprite.func_94212_f(), (double)woodSprite.func_94210_h()).func_181675_d();
            buffer.func_181662_b(-0.5, 0.5, 0.3).func_187315_a((double)woodSprite.func_94212_f(), (double)woodSprite.func_94206_g()).func_181675_d();
            buffer.func_181662_b(-0.5, 0.5, 0.3).func_187315_a((double)woodSprite.func_94212_f(), (double)woodSprite.func_94210_h()).func_181675_d();
            buffer.func_181662_b(-0.5, -0.5, -0.7).func_187315_a((double)woodSprite.func_94212_f(), (double)woodSprite.func_94206_g()).func_181675_d();
            buffer.func_181662_b(-0.5, -0.5, -0.5).func_187315_a((double)woodSprite.func_94209_e(), (double)woodSprite.func_94206_g()).func_181675_d();
            buffer.func_181662_b(-0.5, 0.3, 0.3).func_187315_a((double)woodSprite.func_94209_e(), (double)woodSprite.func_94210_h()).func_181675_d();
            buffer.func_181662_b(-0.5, -0.5, -0.7).func_187315_a((double)woodTopSprite.func_94209_e(), (double)woodTopSprite.func_94206_g()).func_181675_d();
            buffer.func_181662_b(-0.3, -0.5, -0.7).func_187315_a((double)woodTopSprite.func_94212_f(), (double)woodTopSprite.func_94206_g()).func_181675_d();
            buffer.func_181662_b(-0.3, -0.5, -0.5).func_187315_a((double)woodTopSprite.func_94212_f(), (double)woodTopSprite.func_94210_h()).func_181675_d();
            buffer.func_181662_b(-0.5, -0.5, -0.5).func_187315_a((double)woodTopSprite.func_94209_e(), (double)woodTopSprite.func_94210_h()).func_181675_d();
        }
        t.func_78381_a();
        GlStateManager.func_179114_b((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        if (withWood) {
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            if (isTop) {
                buffer.func_181662_b(0.5, 0.3, 0.3).func_187315_a((double)woodSprite.func_94212_f(), (double)woodSprite.func_94210_h()).func_181675_d();
                buffer.func_181662_b(0.5, -0.5, -0.5).func_187315_a((double)woodSprite.func_94212_f(), (double)woodSprite.func_94206_g()).func_181675_d();
                buffer.func_181662_b(0.5, -0.5, -0.7).func_187315_a((double)woodSprite.func_94209_e(), (double)woodSprite.func_94206_g()).func_181675_d();
                buffer.func_181662_b(0.5, 0.5, 0.3).func_187315_a((double)woodSprite.func_94209_e(), (double)woodSprite.func_94210_h()).func_181675_d();
                buffer.func_181662_b(0.5, 0.5, 0.3).func_187315_a((double)woodSprite.func_94212_f(), (double)woodSprite.func_94210_h()).func_181675_d();
                buffer.func_181662_b(0.5, -0.5, -0.7).func_187315_a((double)woodSprite.func_94212_f(), (double)woodSprite.func_94206_g()).func_181675_d();
                buffer.func_181662_b(0.3, -0.5, -0.7).func_187315_a((double)woodSprite.func_94209_e(), (double)woodSprite.func_94206_g()).func_181675_d();
                buffer.func_181662_b(0.3, 0.5, 0.3).func_187315_a((double)woodSprite.func_94209_e(), (double)woodSprite.func_94210_h()).func_181675_d();
                buffer.func_181662_b(0.3, 0.5, 0.3).func_187315_a((double)woodSprite.func_94212_f(), (double)woodSprite.func_94210_h()).func_181675_d();
                buffer.func_181662_b(0.3, -0.5, -0.7).func_187315_a((double)woodSprite.func_94212_f(), (double)woodSprite.func_94206_g()).func_181675_d();
                buffer.func_181662_b(0.3, -0.5, -0.5).func_187315_a((double)woodSprite.func_94209_e(), (double)woodSprite.func_94206_g()).func_181675_d();
                buffer.func_181662_b(0.3, 0.3, 0.3).func_187315_a((double)woodSprite.func_94209_e(), (double)woodSprite.func_94210_h()).func_181675_d();
                buffer.func_181662_b(0.3, -0.5, -0.7).func_187315_a((double)woodTopSprite.func_94209_e(), (double)woodTopSprite.func_94206_g()).func_181675_d();
                buffer.func_181662_b(0.5, -0.5, -0.7).func_187315_a((double)woodTopSprite.func_94212_f(), (double)woodTopSprite.func_94206_g()).func_181675_d();
                buffer.func_181662_b(0.5, -0.5, -0.5).func_187315_a((double)woodTopSprite.func_94212_f(), (double)woodTopSprite.func_94210_h()).func_181675_d();
                buffer.func_181662_b(0.3, -0.5, -0.5).func_187315_a((double)woodTopSprite.func_94209_e(), (double)woodTopSprite.func_94210_h()).func_181675_d();
            }
            buffer.func_181662_b(0.3, 0.5, 0.5).func_187315_a((double)woodSprite.func_94212_f(), (double)woodSprite.func_94206_g()).func_181675_d();
            buffer.func_181662_b(0.5, 0.5, 0.5).func_187315_a((double)woodSprite.func_94209_e(), (double)woodSprite.func_94206_g()).func_181675_d();
            buffer.func_181662_b(0.5, 0.5, 0.3).func_187315_a((double)woodSprite.func_94209_e(), (double)woodSprite.func_94210_h()).func_181675_d();
            buffer.func_181662_b(0.3, 0.5, 0.3).func_187315_a((double)woodSprite.func_94212_f(), (double)woodSprite.func_94210_h()).func_181675_d();
            buffer.func_181662_b(0.3, 0.3, 0.5).func_187315_a((double)woodSprite.func_94212_f(), (double)woodSprite.func_94210_h()).func_181675_d();
            buffer.func_181662_b(0.3, 0.3, 0.3).func_187315_a((double)woodSprite.func_94212_f(), (double)woodSprite.func_94206_g()).func_181675_d();
            buffer.func_181662_b(0.5, 0.3, 0.3).func_187315_a((double)woodSprite.func_94209_e(), (double)woodSprite.func_94206_g()).func_181675_d();
            buffer.func_181662_b(0.5, 0.3, 0.5).func_187315_a((double)woodSprite.func_94209_e(), (double)woodSprite.func_94210_h()).func_181675_d();
            buffer.func_181662_b(0.5, 0.5, 0.3).func_187315_a((double)woodTopSprite.func_94209_e(), (double)woodTopSprite.func_94206_g()).func_181675_d();
            buffer.func_181662_b(0.5, 0.3, 0.3).func_187315_a((double)woodTopSprite.func_94209_e(), (double)woodTopSprite.func_94210_h()).func_181675_d();
            buffer.func_181662_b(0.3, 0.3, 0.3).func_187315_a((double)woodTopSprite.func_94212_f(), (double)woodTopSprite.func_94210_h()).func_181675_d();
            buffer.func_181662_b(0.3, 0.5, 0.3).func_187315_a((double)woodTopSprite.func_94212_f(), (double)woodTopSprite.func_94206_g()).func_181675_d();
            buffer.func_181662_b(0.3, 0.5, 0.3).func_187315_a((double)woodTopSprite.func_94209_e(), (double)woodTopSprite.func_94206_g()).func_181675_d();
            buffer.func_181662_b(0.3, 0.3, 0.3).func_187315_a((double)woodTopSprite.func_94209_e(), (double)woodTopSprite.func_94210_h()).func_181675_d();
            buffer.func_181662_b(0.3, 0.3, 0.5).func_187315_a((double)woodTopSprite.func_94212_f(), (double)woodTopSprite.func_94210_h()).func_181675_d();
            buffer.func_181662_b(0.3, 0.5, 0.5).func_187315_a((double)woodTopSprite.func_94212_f(), (double)woodTopSprite.func_94206_g()).func_181675_d();
            t.func_78381_a();
        }
        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
    }
}

