/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics;

import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.IAlleleFruit;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.TreeManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleInteger;
import forestry.api.genetics.IAlyzerPlugin;
import forestry.api.genetics.IFruitFamily;
import forestry.arboriculture.PluginArboriculture;
import forestry.arboriculture.genetics.TreeGenome;
import forestry.arboriculture.genetics.alleles.AlleleFruit;
import forestry.core.config.Config;
import forestry.core.gui.GuiAlyzer;
import forestry.core.gui.TextLayoutHelper;
import forestry.core.gui.widgets.ItemStackWidget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.proxy.Proxies;
import forestry.core.utils.Translator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TreeAlyzerPlugin
implements IAlyzerPlugin {
    public static final TreeAlyzerPlugin INSTANCE = new TreeAlyzerPlugin();
    protected final Map<String, ItemStack> iconStacks = new HashMap<String, ItemStack>();

    private TreeAlyzerPlugin() {
        ArrayList<ItemStack> treeList = new ArrayList<ItemStack>();
        PluginArboriculture.items.sapling.addCreativeItems(treeList, false);
        for (ItemStack treeStack : treeList) {
            IAlleleTreeSpecies species = TreeGenome.getSpecies(treeStack);
            if (species == null) continue;
            this.iconStacks.put(species.getUID(), treeStack);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawAnalyticsPage1(GuiScreen gui, ItemStack itemStack) {
        if (gui instanceof GuiAlyzer) {
            GuiAlyzer guiAlyzer = (GuiAlyzer)gui;
            ITree tree = TreeManager.treeRoot.getMember(itemStack);
            if (tree == null) {
                return;
            }
            EnumGermlingType type = TreeManager.treeRoot.getType(itemStack);
            TextLayoutHelper textLayout = guiAlyzer.getTextLayout();
            textLayout.startPage(12, 90, 155);
            textLayout.drawLine(Translator.translateToLocal("for.gui.active"), 90);
            textLayout.drawLine(Translator.translateToLocal("for.gui.inactive"), 155);
            textLayout.newLine();
            textLayout.newLine();
            String customPrimaryTreeKey = "trees.custom.treealyzer." + type.getName() + "." + tree.getGenome().getPrimary().getUnlocalizedName().replace("trees.species.", "");
            String customSecondaryTreeKey = "trees.custom.treealyzer." + type.getName() + "." + tree.getGenome().getSecondary().getUnlocalizedName().replace("trees.species.", "");
            guiAlyzer.drawSpeciesRow(Translator.translateToLocal("for.gui.species"), tree, EnumTreeChromosome.SPECIES, GuiAlyzer.checkCustomName(customPrimaryTreeKey), GuiAlyzer.checkCustomName(customSecondaryTreeKey));
            textLayout.newLine();
            guiAlyzer.drawChromosomeRow(Translator.translateToLocal("for.gui.saplings"), tree, EnumTreeChromosome.FERTILITY);
            textLayout.newLineCompressed();
            guiAlyzer.drawChromosomeRow(Translator.translateToLocal("for.gui.maturity"), tree, EnumTreeChromosome.MATURATION);
            textLayout.newLineCompressed();
            guiAlyzer.drawChromosomeRow(Translator.translateToLocal("for.gui.height"), tree, EnumTreeChromosome.HEIGHT);
            textLayout.newLineCompressed();
            IAlleleInteger activeGirth = (IAlleleInteger)tree.getGenome().getActiveAllele(EnumTreeChromosome.GIRTH);
            IAlleleInteger inactiveGirth = (IAlleleInteger)tree.getGenome().getInactiveAllele(EnumTreeChromosome.GIRTH);
            textLayout.drawLine(Translator.translateToLocal("for.gui.girth"), 12);
            guiAlyzer.drawLine(String.format("%sx%s", activeGirth.getValue(), activeGirth.getValue()), 90, tree, EnumTreeChromosome.GIRTH, false);
            guiAlyzer.drawLine(String.format("%sx%s", inactiveGirth.getValue(), inactiveGirth.getValue()), 155, tree, EnumTreeChromosome.GIRTH, true);
            textLayout.newLineCompressed();
            guiAlyzer.drawChromosomeRow(Translator.translateToLocal("for.gui.yield"), tree, EnumTreeChromosome.YIELD);
            textLayout.newLineCompressed();
            guiAlyzer.drawChromosomeRow(Translator.translateToLocal("for.gui.sappiness"), tree, EnumTreeChromosome.SAPPINESS);
            textLayout.newLineCompressed();
            guiAlyzer.drawChromosomeRow(Translator.translateToLocal("for.gui.effect"), tree, EnumTreeChromosome.EFFECT);
            textLayout.endPage();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawAnalyticsPage2(GuiScreen gui, ItemStack itemStack) {
        if (gui instanceof GuiAlyzer) {
            GuiAlyzer guiAlyzer = (GuiAlyzer)gui;
            ITree tree = TreeManager.treeRoot.getMember(itemStack);
            if (tree == null) {
                return;
            }
            TextLayoutHelper textLayout = guiAlyzer.getTextLayout();
            textLayout.startPage();
            int speciesDominance0 = guiAlyzer.getColorCoding(tree.getGenome().getPrimary().isDominant());
            int speciesDominance1 = guiAlyzer.getColorCoding(tree.getGenome().getSecondary().isDominant());
            textLayout.drawLine(Translator.translateToLocal("for.gui.active"), 90);
            textLayout.drawLine(Translator.translateToLocal("for.gui.inactive"), 155);
            textLayout.newLine();
            textLayout.newLine();
            IAlleleTreeSpecies activeSpecies = (IAlleleTreeSpecies)tree.getGenome().getActiveAllele(EnumTreeChromosome.SPECIES);
            IAlleleTreeSpecies inActiveSpecies = (IAlleleTreeSpecies)tree.getGenome().getInactiveAllele(EnumTreeChromosome.SPECIES);
            int activeCarbonization = activeSpecies.getWoodProvider().getCarbonization();
            int inactiveCarbonization = inActiveSpecies.getWoodProvider().getCarbonization();
            textLayout.drawLine(Translator.translateToLocal("for.gui.carbonization"), 12);
            guiAlyzer.drawLine(Integer.toString(activeCarbonization), 90, tree, EnumTreeChromosome.SPECIES, false);
            guiAlyzer.drawLine(Integer.toString(inactiveCarbonization), 155, tree, EnumTreeChromosome.SPECIES, true);
            textLayout.newLine();
            textLayout.drawLine(Translator.translateToLocal("for.gui.native"), 12);
            textLayout.drawLine(Translator.translateToLocal("for.gui." + tree.getGenome().getPrimary().getPlantType().toString().toLowerCase(Locale.ENGLISH)), 90, speciesDominance0);
            textLayout.drawLine(Translator.translateToLocal("for.gui." + tree.getGenome().getSecondary().getPlantType().toString().toLowerCase(Locale.ENGLISH)), 155, speciesDominance1);
            textLayout.newLine();
            textLayout.drawLine(Translator.translateToLocal("for.gui.supports"), 12);
            ArrayList<IFruitFamily> families0 = new ArrayList<IFruitFamily>(tree.getGenome().getPrimary().getSuitableFruit());
            ArrayList<IFruitFamily> families1 = new ArrayList<IFruitFamily>(tree.getGenome().getSecondary().getSuitableFruit());
            int max = Math.max(families0.size(), families1.size());
            for (int i = 0; i < max; ++i) {
                if (i > 0) {
                    textLayout.newLineCompressed();
                }
                if (families0.size() > i) {
                    textLayout.drawLine(((IFruitFamily)families0.get(i)).getName(), 90, speciesDominance0);
                }
                if (families1.size() <= i) continue;
                textLayout.drawLine(((IFruitFamily)families1.get(i)).getName(), 155, speciesDominance1);
            }
            textLayout.newLine();
            int fruitDominance0 = guiAlyzer.getColorCoding(tree.getGenome().getActiveAllele(EnumTreeChromosome.FRUITS).isDominant());
            int fruitDominance1 = guiAlyzer.getColorCoding(tree.getGenome().getInactiveAllele(EnumTreeChromosome.FRUITS).isDominant());
            textLayout.drawLine(Translator.translateToLocal("for.gui.fruits"), 12);
            String strike = "";
            IAllele fruit0 = tree.getGenome().getActiveAllele(EnumTreeChromosome.FRUITS);
            if (!tree.canBearFruit() && fruit0 != AlleleFruit.fruitNone) {
                strike = TextFormatting.STRIKETHROUGH.toString();
            }
            textLayout.drawLine(strike + tree.getGenome().getFruitProvider().getDescription(), 90, fruitDominance0);
            strike = "";
            IAlleleFruit fruit1 = (IAlleleFruit)tree.getGenome().getInactiveAllele(EnumTreeChromosome.FRUITS);
            if (!tree.getGenome().getSecondary().getSuitableFruit().contains(fruit1.getProvider().getFamily()) && fruit1 != AlleleFruit.fruitNone) {
                strike = TextFormatting.STRIKETHROUGH.toString();
            }
            textLayout.drawLine(strike + fruit1.getProvider().getDescription(), 155, fruitDominance1);
            textLayout.newLine();
            textLayout.drawLine(Translator.translateToLocal("for.gui.family"), 12);
            IFruitFamily primary = tree.getGenome().getFruitProvider().getFamily();
            IFruitFamily secondary = ((IAlleleFruit)tree.getGenome().getInactiveAllele(EnumTreeChromosome.FRUITS)).getProvider().getFamily();
            if (primary != null) {
                textLayout.drawLine(primary.getName(), 90, fruitDominance0);
            }
            if (secondary != null) {
                textLayout.drawLine(secondary.getName(), 155, fruitDominance1);
            }
            textLayout.endPage();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawAnalyticsPage3(GuiScreen gui, ItemStack itemStack) {
        if (gui instanceof GuiAlyzer) {
            GuiAlyzer guiAlyzer = (GuiAlyzer)gui;
            ITree tree = TreeManager.treeRoot.getMember(itemStack);
            if (tree == null) {
                return;
            }
            TextLayoutHelper textLayout = guiAlyzer.getTextLayout();
            WidgetManager widgetManager = guiAlyzer.getWidgetManager();
            textLayout.startPage(12, 90, 155);
            textLayout.drawLine(Translator.translateToLocal("for.gui.beealyzer.produce") + ":", 12);
            textLayout.newLine();
            int x = 12;
            for (ItemStack stack : tree.getProducts().keySet()) {
                widgetManager.add(new ItemStackWidget(widgetManager, x, textLayout.getLineY(), stack));
                if ((x += 18) <= 148) continue;
                x = 12;
                textLayout.newLine();
            }
            textLayout.newLine();
            textLayout.newLine();
            textLayout.newLine();
            textLayout.newLine();
            textLayout.drawLine(Translator.translateToLocal("for.gui.beealyzer.specialty") + ":", 12);
            textLayout.newLine();
            x = 12;
            for (ItemStack stack : tree.getSpecialties().keySet()) {
                Proxies.common.getClientInstance().func_175599_af().func_175042_a(stack, guiAlyzer.getGuiLeft() + x, guiAlyzer.getGuiTop() + textLayout.getLineY());
                if ((x += 18) <= 148) continue;
                x = 12;
                textLayout.newLine();
            }
            textLayout.endPage();
        }
    }

    @Override
    public Map<String, ItemStack> getIconStacks() {
        return this.iconStacks;
    }

    @Override
    public List<String> getHints() {
        return Config.hints.get((Object)"treealyzer");
    }
}

