/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks.log;

import forestry.api.arboriculture.EnumVanillaWoodType;
import forestry.arboriculture.blocks.log.BlockForestryLog;
import forestry.arboriculture.blocks.property.PropertyVanillaWoodType;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public abstract class BlockFireproofVanillaLog
extends BlockForestryLog<EnumVanillaWoodType> {
    public static List<BlockFireproofVanillaLog> create() {
        ArrayList<BlockFireproofVanillaLog> blocks = new ArrayList<BlockFireproofVanillaLog>();
        PropertyVanillaWoodType[] variants = PropertyVanillaWoodType.create("variant", 4);
        for (int i = 0; i < variants.length; ++i) {
            final PropertyVanillaWoodType variant = variants[i];
            BlockFireproofVanillaLog block = new BlockFireproofVanillaLog(i){

                @Nonnull
                public PropertyVanillaWoodType getVariant() {
                    return variant;
                }
            };
            blocks.add(block);
        }
        return blocks;
    }

    private BlockFireproofVanillaLog(int blockNumber) {
        super(true, blockNumber);
    }

    @Override
    @Nonnull
    public EnumVanillaWoodType getWoodType(int meta) {
        int variantCount = this.getVariant().func_177700_c().size();
        int variantMeta = meta % variantCount + this.getBlockNumber() * 4;
        return EnumVanillaWoodType.byMetadata(variantMeta);
    }
}

