/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks.fence;

import forestry.api.arboriculture.EnumVanillaWoodType;
import forestry.arboriculture.blocks.fence.BlockForestryFence;
import forestry.arboriculture.blocks.property.PropertyVanillaWoodType;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public abstract class BlockFireproofVanillaFence
extends BlockForestryFence<EnumVanillaWoodType> {
    public static List<BlockFireproofVanillaFence> create() {
        ArrayList<BlockFireproofVanillaFence> blocks = new ArrayList<BlockFireproofVanillaFence>();
        PropertyVanillaWoodType[] variants = PropertyVanillaWoodType.create("variant", 16);
        for (int i = 0; i < variants.length; ++i) {
            final PropertyVanillaWoodType variant = variants[i];
            BlockFireproofVanillaFence block = new BlockFireproofVanillaFence(i){

                @Nonnull
                public PropertyVanillaWoodType getVariant() {
                    return variant;
                }
            };
            blocks.add(block);
        }
        return blocks;
    }

    private BlockFireproofVanillaFence(int blockNumber) {
        super(true, blockNumber);
    }

    @Override
    @Nonnull
    public EnumVanillaWoodType getWoodType(int meta) {
        int variantCount = this.getVariant().func_177700_c().size();
        int variantMeta = meta % variantCount + this.getBlockNumber() * 16;
        return EnumVanillaWoodType.byMetadata(variantMeta);
    }
}

