/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics.alleles;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IEffectData;
import forestry.apiculture.genetics.alleles.AlleleEffectAggressive;
import forestry.apiculture.genetics.alleles.AlleleEffectCreeper;
import forestry.apiculture.genetics.alleles.AlleleEffectExploration;
import forestry.apiculture.genetics.alleles.AlleleEffectFertile;
import forestry.apiculture.genetics.alleles.AlleleEffectFungification;
import forestry.apiculture.genetics.alleles.AlleleEffectGlacial;
import forestry.apiculture.genetics.alleles.AlleleEffectHeroic;
import forestry.apiculture.genetics.alleles.AlleleEffectIgnition;
import forestry.apiculture.genetics.alleles.AlleleEffectMisanthrope;
import forestry.apiculture.genetics.alleles.AlleleEffectNone;
import forestry.apiculture.genetics.alleles.AlleleEffectPotion;
import forestry.apiculture.genetics.alleles.AlleleEffectRadioactive;
import forestry.apiculture.genetics.alleles.AlleleEffectRepulsion;
import forestry.apiculture.genetics.alleles.AlleleEffectResurrection;
import forestry.apiculture.genetics.alleles.AlleleEffectSnowing;
import forestry.core.genetics.alleles.AlleleCategorized;
import forestry.core.proxy.Proxies;
import forestry.core.utils.VectUtil;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.init.MobEffects;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public abstract class AlleleEffect
extends AlleleCategorized
implements IAlleleBeeEffect {
    public static IAlleleBeeEffect effectNone;
    public static IAlleleBeeEffect effectAggressive;
    public static IAlleleBeeEffect effectHeroic;
    public static IAlleleBeeEffect effectBeatific;
    public static IAlleleBeeEffect effectMiasmic;
    public static IAlleleBeeEffect effectMisanthrope;
    public static IAlleleBeeEffect effectGlacial;
    public static IAlleleBeeEffect effectRadioactive;
    public static IAlleleBeeEffect effectCreeper;
    public static IAlleleBeeEffect effectIgnition;
    public static IAlleleBeeEffect effectExploration;
    public static IAlleleBeeEffect effectFestiveEaster;
    public static IAlleleBeeEffect effectSnowing;
    public static IAlleleBeeEffect effectDrunkard;
    public static IAlleleBeeEffect effectReanimation;
    public static IAlleleBeeEffect effectResurrection;
    public static IAlleleBeeEffect effectRepulsion;
    public static IAlleleBeeEffect effectFertile;
    public static IAlleleBeeEffect effectMycophilic;

    public static void createAlleles() {
        effectNone = new AlleleEffectNone("none", true);
        effectAggressive = new AlleleEffectAggressive();
        effectHeroic = new AlleleEffectHeroic();
        effectBeatific = new AlleleEffectPotion("beatific", false, MobEffects.field_76428_l, 100);
        effectMiasmic = new AlleleEffectPotion("miasmic", false, MobEffects.field_76436_u, 600, 100, 0.1f);
        effectMisanthrope = new AlleleEffectMisanthrope();
        effectGlacial = new AlleleEffectGlacial();
        effectRadioactive = new AlleleEffectRadioactive();
        effectCreeper = new AlleleEffectCreeper();
        effectIgnition = new AlleleEffectIgnition();
        effectExploration = new AlleleEffectExploration();
        effectFestiveEaster = new AlleleEffectNone("festiveEaster", true);
        effectSnowing = new AlleleEffectSnowing();
        effectDrunkard = new AlleleEffectPotion("drunkard", false, MobEffects.field_76431_k, 100);
        effectReanimation = new AlleleEffectResurrection("reanimation", AlleleEffectResurrection.getReanimationList());
        List<IAlleleBeeEffect> beeEffects = Arrays.asList(effectNone, effectAggressive, effectHeroic, effectBeatific, effectMiasmic, effectMisanthrope, effectGlacial, effectRadioactive, effectCreeper, effectIgnition, effectExploration, effectFestiveEaster, effectSnowing, effectDrunkard, effectReanimation, effectResurrection = new AlleleEffectResurrection("resurrection", AlleleEffectResurrection.getResurrectionList()), effectRepulsion = new AlleleEffectRepulsion(), effectFertile = new AlleleEffectFertile(), effectMycophilic = new AlleleEffectFungification());
        for (IAlleleBeeEffect beeEffect : beeEffects) {
            AlleleManager.alleleRegistry.registerAllele(beeEffect, EnumBeeChromosome.EFFECT);
        }
    }

    protected AlleleEffect(String valueName, boolean isDominant) {
        super("forestry", "effect", valueName, isDominant);
    }

    @Override
    public IEffectData validateStorage(IEffectData storedData) {
        return null;
    }

    @Override
    public boolean isCombinable() {
        return false;
    }

    @Override
    public IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        return storedData;
    }

    @Override
    public IEffectData doFX(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        IBeekeepingLogic beekeepingLogic = housing.getBeekeepingLogic();
        List<BlockPos> flowerPositions = beekeepingLogic.getFlowerPositions();
        Proxies.render.addBeeHiveFX(housing, genome, flowerPositions);
        return storedData;
    }

    public static Vec3i getModifiedArea(IBeeGenome genome, IBeeHousing housing) {
        IBeeModifier beeModifier = BeeManager.beeRoot.createBeeHousingModifier(housing);
        float territoryModifier = beeModifier.getTerritoryModifier(genome, 1.0f);
        BlockPos area = VectUtil.scale(genome.getTerritory(), territoryModifier);
        int x = area.func_177958_n();
        int y = area.func_177956_o();
        int z = area.func_177952_p();
        if (x < 1) {
            x = 1;
        }
        if (y < 1) {
            y = 1;
        }
        if (z < 1) {
            z = 1;
        }
        return new Vec3i(x, y, z);
    }

    public static AxisAlignedBB getBounding(IBeeGenome genome, IBeeHousing housing) {
        IBeeModifier beeModifier = BeeManager.beeRoot.createBeeHousingModifier(housing);
        float territoryModifier = beeModifier.getTerritoryModifier(genome, 1.0f);
        BlockPos area = VectUtil.scale(genome.getTerritory(), territoryModifier);
        BlockPos offset = VectUtil.scale((Vec3i)area, -0.5f);
        BlockPos min = housing.getCoordinates().func_177971_a((Vec3i)offset);
        BlockPos max = min.func_177971_a((Vec3i)area);
        return new AxisAlignedBB((double)min.func_177958_n(), (double)min.func_177956_o(), (double)min.func_177952_p(), (double)max.func_177958_n(), (double)max.func_177956_o(), (double)max.func_177952_p());
    }

    public static <T extends Entity> List<T> getEntitiesInRange(IBeeGenome genome, IBeeHousing housing, Class<T> entityClass) {
        AxisAlignedBB boundingBox = AlleleEffect.getBounding(genome, housing);
        return housing.getWorldObj().func_72872_a(entityClass, boundingBox);
    }
}

