/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IBeeHousingInventory;
import forestry.core.inventory.InventoryAdapterRestricted;
import forestry.core.utils.InventoryUtil;
import forestry.core.utils.SlotUtil;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;

public class InventoryBeeHousing
extends InventoryAdapterRestricted
implements IBeeHousingInventory {
    public static final int SLOT_QUEEN = 0;
    public static final int SLOT_DRONE = 1;
    public static final int SLOT_PRODUCT_1 = 2;
    public static final int SLOT_PRODUCT_COUNT = 7;

    public InventoryBeeHousing(int size) {
        super(size, "Items");
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        EnumBeeType beeType = BeeManager.beeRoot.getType(itemStack);
        if (slotIndex == 0) {
            return beeType == EnumBeeType.QUEEN || beeType == EnumBeeType.PRINCESS;
        }
        if (slotIndex == 1) {
            return beeType == EnumBeeType.DRONE;
        }
        return false;
    }

    @Override
    public boolean func_180461_b(int slotIndex, ItemStack itemstack, EnumFacing side) {
        if (!super.func_180461_b(slotIndex, itemstack, side)) {
            return false;
        }
        return SlotUtil.isSlotInRange(slotIndex, 2, 7);
    }

    @Override
    public final ItemStack getQueen() {
        return this.func_70301_a(0);
    }

    @Override
    public final ItemStack getDrone() {
        return this.func_70301_a(1);
    }

    @Override
    public final void setQueen(ItemStack itemstack) {
        this.func_70299_a(0, itemstack);
    }

    @Override
    public final void setDrone(ItemStack itemstack) {
        this.func_70299_a(1, itemstack);
    }

    @Override
    public final boolean addProduct(ItemStack product, boolean all) {
        return InventoryUtil.tryAddStack((IInventory)this, product, 2, 7, all, true);
    }
}

