/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutils.network;

import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class NetworkHandler {
    private final SimpleNetworkWrapper network;
    private int curDiscriminator = 0;

    public NetworkHandler(String netId) {
        this.network = NetworkRegistry.INSTANCE.newSimpleChannel(netId);
    }

    public void register(Class clazz, Side side) {
        this.network.registerMessage(clazz, clazz, this.curDiscriminator++, side);
    }

    public void sendToAll(IMessage message) {
        this.network.sendToAll(message);
    }

    public void sendTo(IMessage message, EntityPlayerMP player) {
        this.network.sendTo(message, player);
    }

    public void sendToAllAround(IMessage message, World world, BlockPos pos, double range) {
        this.sendToAllAround(message, new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, range));
    }

    public void sendToAllAround(IMessage message, NetworkRegistry.TargetPoint point) {
        this.network.sendToAllAround(message, point);
    }

    public void sendToDimension(IMessage message, int dimensionId) {
        this.network.sendToDimension(message, dimensionId);
    }

    public void sendToServer(IMessage message) {
        this.network.sendToServer(message);
    }
}

