/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutils.features.potion;

import net.darkhax.darkutils.features.Feature;
import net.darkhax.darkutils.features.potion.ItemMysteriousPotion;
import net.darkhax.darkutils.features.potion.PotionColorHandler;
import net.darkhax.darkutils.libs.ModUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.item.Item;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.SetDamage;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FeaturePotion
extends Feature {
    public static Item itemPotion;
    private static boolean dungeonLoot;
    private static int weight;

    @Override
    public void onPreInit() {
        itemPotion = new ItemMysteriousPotion();
        ModUtils.registerItem(itemPotion, "mystery_potion");
    }

    @Override
    public void setupConfiguration(Configuration config) {
        dungeonLoot = config.getBoolean("Dungeon Loot", this.configName, true, "Should mysterious potions show up in dungeon chests?");
        weight = config.getInt("Dungeon Weight", this.configName, 5, 0, 10, "Weight for potions in dungeon chests");
    }

    @Override
    public boolean usesEvents() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onClientPreInit() {
        ModUtils.registerItemInvModel(itemPotion, 0, "bottle_drinkable");
        ModUtils.registerItemInvModel(itemPotion, 1, "bottle_drinkable");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onClientInit() {
        Minecraft.func_71410_x().getItemColors().func_186730_a((IItemColor)new PotionColorHandler(), new Item[]{itemPotion});
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        if (dungeonLoot) {
            LootPool main;
            LootTable table = event.getTable();
            if (event.getName().equals((Object)LootTableList.field_186422_d) && (main = table.getPool("main")) != null) {
                main.addEntry((LootEntry)new LootEntryItem(itemPotion, weight, 0, new LootFunction[]{new SetDamage(new LootCondition[0], new RandomValueRange(0.0f, 1.0f))}, new LootCondition[0], "darkutils:mysterious_potion"));
            }
        }
    }
}

