/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.shadowmc.util;

import java.beans.ConstructorProperties;
import net.minecraft.client.renderer.GlStateManager;

public class Color {
    public static final Color BLACK = new Color(-16777216);
    public static final Color DARK_BLUE = new Color(-16777046);
    public static final Color DARK_GREEN = new Color(-16733696);
    public static final Color DARK_AQUA = new Color(-16733526);
    public static final Color DARK_RED = new Color(-5636096);
    public static final Color DARK_PURPLE = new Color(-5635926);
    public static final Color GOLD = new Color(-22016);
    public static final Color GRAY = new Color(-5592406);
    public static final Color DARK_GRAY = new Color(-11184811);
    public static final Color BLUE = new Color(-11184641);
    public static final Color GREEN = new Color(-11141291);
    public static final Color AQUA = new Color(-11141121);
    public static final Color LIGHT_PURPLE = new Color(-43521);
    public static final Color YELLOW = new Color(-171);
    public static final Color WHITE = new Color(-1);
    public static final Color PURE_RED = new Color(-65536);
    public static final Color PURE_GREEN = new Color(-16711936);
    public static final Color PURE_BLUE = new Color(-16776961);
    public static final Color TRANSPARENT = new Color(0);
    private float alpha = 1.0f;
    private float red;
    private float green;
    private float blue;

    public Color(int color) {
        this.alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        this.red = (float)(color >> 16 & 0xFF) / 255.0f;
        this.green = (float)(color >> 8 & 0xFF) / 255.0f;
        this.blue = (float)(color & 0xFF) / 255.0f;
    }

    public int toARGB() {
        return Color.toARGB((int)(this.alpha * 255.0f), (int)(this.red * 255.0f), (int)(this.green * 255.0f), (int)(this.blue * 255.0f));
    }

    public String toString() {
        return String.format("Color(alpha=%f, red=%f, green=%f, blue=%f, ARGB=%x", Float.valueOf(this.alpha), Float.valueOf(this.red), Float.valueOf(this.green), Float.valueOf(this.blue), this.toARGB());
    }

    public static int toARGB(int a, int r, int g, int b) {
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public void apply() {
        GlStateManager.func_179131_c((float)this.red, (float)this.green, (float)this.blue, (float)this.alpha);
    }

    @ConstructorProperties(value={"alpha", "red", "green", "blue"})
    public Color(float alpha, float red, float green, float blue) {
        this.alpha = alpha;
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public float getRed() {
        return this.red;
    }

    public float getGreen() {
        return this.green;
    }

    public float getBlue() {
        return this.blue;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    public void setRed(float red) {
        this.red = red;
    }

    public void setGreen(float green) {
        this.green = green;
    }

    public void setBlue(float blue) {
        this.blue = blue;
    }
}

