/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.shadowmc.ui.element;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.shadowfacts.shadowmc.ui.UIDimensions;
import net.shadowfacts.shadowmc.ui.element.UIElementBase;
import net.shadowfacts.shadowmc.ui.style.UIAttribute;
import net.shadowfacts.shadowmc.ui.style.UIHorizontalLayoutMode;
import net.shadowfacts.shadowmc.ui.style.UIVerticalLayoutMode;
import net.shadowfacts.shadowmc.ui.util.UIHelper;

public class UILabel
extends UIElementBase {
    private String text;
    private int width;

    public UILabel(String text, int width, String id, String ... classes) {
        super("label", id, classes);
        this.text = text;
        this.width = width;
    }

    public UILabel(String text, String id, String ... classes) {
        this(text, Minecraft.func_71410_x().field_71466_p.func_78256_a(text), id, classes);
    }

    @Override
    public UIDimensions getMinDimensions() {
        return new UIDimensions(this.mc.field_71466_p.func_78256_a(UIHelper.styleText(this.text, this)), this.mc.field_71466_p.field_78288_b);
    }

    @Override
    public UIDimensions getPreferredDimensions() {
        return new UIDimensions(this.width, this.mc.field_71466_p.field_78288_b);
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        int yOffset;
        int xOffset;
        UIHorizontalLayoutMode horizontalLayoutMode = this.getStyle(UIAttribute.TEXT_HORIZONTAL_LAYOUT);
        UIVerticalLayoutMode verticalLayoutMode = this.getStyle(UIAttribute.TEXT_VERTICAL_LAYOUT);
        Color color = this.getStyle(UIAttribute.TEXT_COLOR);
        boolean shadow = this.getStyle(UIAttribute.TEXT_SHADOW);
        switch (horizontalLayoutMode) {
            default: {
                xOffset = 0;
                break;
            }
            case CENTER: {
                xOffset = (this.dimensions.width - this.mc.field_71466_p.func_78256_a(this.text)) / 2;
                break;
            }
            case RIGHT: {
                xOffset = this.dimensions.width - this.mc.field_71466_p.func_78256_a(this.text);
            }
        }
        switch (verticalLayoutMode) {
            default: {
                yOffset = 0;
                break;
            }
            case CENTER: {
                yOffset = -this.dimensions.height / 2;
                break;
            }
            case BOTTOM: {
                yOffset = this.dimensions.height - this.mc.field_71466_p.field_78288_b;
            }
        }
        this.mc.field_71466_p.func_175065_a(UIHelper.styleText(this.text, this), (float)(this.x + xOffset), (float)(this.y + yOffset), UIHelper.toARGB(color), shadow);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void drawTooltip(int mouseX, int mouseY) {
    }

    public void setText(String text) {
        this.text = text;
    }
}

