/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.shadowmc.structure;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.IForgeRegistry;
import net.shadowfacts.shadowmc.structure.IStructureReloadHandler;
import net.shadowfacts.shadowmc.structure.Structure;

public class StructureManager
implements IForgeRegistry<Structure> {
    public static StructureManager INSTANCE = new StructureManager();
    private static Gson gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(Structure.BlockInfo.class, (Object)new Structure.BlockInfo.Serializer()).create();
    private BiMap<ResourceLocation, Structure> map = HashBiMap.create();
    private Map<ResourceLocation, IStructureReloadHandler> reloadHandlerMap = new HashMap<ResourceLocation, IStructureReloadHandler>();

    public Structure register(ResourceLocation name) {
        Structure structure = this.register(name, this.getClass().getResourceAsStream(String.format("/assets/%s/structures/%s.json", name.func_110624_b(), name.func_110623_a())));
        this.registerReloadHandler(name, this::load);
        return structure;
    }

    public Structure register(ResourceLocation name, InputStream in) {
        Structure structure = this.load(name, in);
        this.register(structure);
        return structure;
    }

    public Structure load(ResourceLocation name) {
        return this.load(name, this.getClass().getResourceAsStream(String.format("/assets/%s/structures/%s.json", name.func_110624_b(), name.func_110623_a())));
    }

    public Structure load(ResourceLocation name, InputStream in) {
        if (in == null) {
            throw new IllegalArgumentException(String.format("Cannot load non-existent structure %s from null InputStream", name));
        }
        Structure structure = (Structure)gson.fromJson((Reader)new InputStreamReader(in), Structure.class);
        structure.setRegistryName(name);
        return structure;
    }

    public void registerReloadHandler(ResourceLocation structure, IStructureReloadHandler handler) {
        if (this.reloadHandlerMap.containsKey(structure)) {
            throw new IllegalArgumentException(String.format("Structure reload handler (%s) for '%s' is already registered to %s", handler, structure, this.reloadHandlerMap.get(structure)));
        }
        this.reloadHandlerMap.put(structure, handler);
    }

    public void reload() {
        for (Map.Entry<ResourceLocation, IStructureReloadHandler> e : this.reloadHandlerMap.entrySet()) {
            Structure structure;
            if (!this.map.containsKey((Object)e.getKey()) || (structure = e.getValue().reload(e.getKey())) == null) continue;
            this.map.put((Object)e.getKey(), (Object)structure);
        }
    }

    public String toJson(Structure structure) {
        return gson.toJson((Object)structure, Structure.class);
    }

    public Class<Structure> getRegistrySuperType() {
        return Structure.class;
    }

    public void register(Structure value) {
        if (this.map.containsKey((Object)value.getRegistryName())) {
            throw new IllegalArgumentException(String.format("Structure (%s) with name '%s' is already registered to %s", value, value.getRegistryName(), this.map.get((Object)value.getRegistryName())));
        }
        this.map.put((Object)value.getRegistryName(), (Object)value);
    }

    public void registerAll(Structure ... values) {
        for (Structure structure : values) {
            this.register(structure);
        }
    }

    public boolean containsKey(ResourceLocation key) {
        return this.map.containsKey((Object)key);
    }

    public boolean containsValue(Structure value) {
        return this.map.containsValue((Object)value);
    }

    public Structure getValue(ResourceLocation key) {
        return (Structure)this.map.get((Object)key);
    }

    public ResourceLocation getKey(Structure value) {
        return (ResourceLocation)this.map.inverse().get((Object)value);
    }

    public Set<ResourceLocation> getKeys() {
        return this.map.keySet();
    }

    public List<Structure> getValues() {
        return ImmutableList.copyOf((Collection)this.map.values());
    }

    public Set<Map.Entry<ResourceLocation, Structure>> getEntries() {
        return this.map.entrySet();
    }

    public <T> T getSlaveMap(ResourceLocation slaveMapName, Class<T> type) {
        return null;
    }

    public Iterator<Structure> iterator() {
        return this.map.values().iterator();
    }

    private StructureManager() {
    }
}

