/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.shadowmc.gui.component.window;

import java.util.Optional;
import net.shadowfacts.shadowmc.gui.AbstractGUI;
import net.shadowfacts.shadowmc.gui.BaseGUI;
import net.shadowfacts.shadowmc.gui.component.button.GUIButton;
import net.shadowfacts.shadowmc.gui.component.window.GUIButtonCloseWindow;
import net.shadowfacts.shadowmc.gui.component.window.GUIButtonMinimizeWindow;
import net.shadowfacts.shadowmc.util.Color;
import net.shadowfacts.shadowmc.util.MouseButton;

public class GUIComponentWindow
extends BaseGUI {
    protected String title;
    protected Color mainColor = Color.GRAY;
    protected Color titleBarColor = Color.DARK_GRAY;
    protected Color titleColor = Color.WHITE;
    protected boolean closable;
    protected boolean minimizable;
    protected boolean minimized = false;

    public GUIComponentWindow(int x, int y, int width, int height, String title, boolean closable, boolean minimizable) {
        super(x, y, width, height);
        this.title = title;
        this.closable = closable;
        this.minimizable = minimizable;
        int leftX = x + width - 10;
        if (closable) {
            this.addChild(new GUIButtonCloseWindow(leftX, y + 5, 10, 10, this));
            leftX -= 15;
        }
        if (minimizable) {
            this.addChild(new GUIButtonMinimizeWindow(leftX, y + 5, 10, 10, this));
        }
    }

    public GUIComponentWindow(int x, int y, int width, int height, String title, boolean closable) {
        this(x, y, width, height, title, closable, true);
    }

    public GUIComponentWindow(int x, int y, int width, int height, String title) {
        this(x, y, width, height, title, false, true);
    }

    public GUIComponentWindow addComponent(AbstractGUI component) {
        this.addChild(component);
        return this;
    }

    @Override
    public boolean isWithinMovableBounds(int x, int y) {
        return x >= this.x && x <= this.x + this.width && y >= this.y && y <= this.y + 20;
    }

    @Override
    public void handleMouseClicked(int mouseX, int mouseY, MouseButton button) {
        if (this.minimized) {
            Optional<GUIButton> gui = this.children.stream().filter(theGui -> theGui instanceof GUIButtonCloseWindow || theGui instanceof GUIButtonMinimizeWindow).filter(AbstractGUI::isVisible).filter(theGui -> theGui.isWithinBounds(mouseX, mouseY)).sorted((gui1, gui2) -> gui1.getZLevel() > gui2.getZLevel() ? -1 : (gui1.getZLevel() < gui2.getZLevel() ? 1 : 0)).map(theGui -> (GUIButton)theGui).findFirst();
            if (gui.isPresent()) {
                gui.get().handleMouseClicked(mouseX, mouseY, button);
            }
        } else {
            super.handleMouseClicked(mouseX, mouseY, button);
        }
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        if (!this.minimized) {
            this.drawRect(this.x, this.y + 20, this.width, this.height - 20, this.mainColor);
        }
        this.drawRect(this.x, this.y, this.width, 20, this.titleBarColor);
        this.drawCenteredText(this.title, this.x + 5, this.x + 5 + this.mc.field_71466_p.func_78256_a(this.title), this.y, this.y + 20, this.titleColor);
        if (this.minimized) {
            this.children.stream().filter(gui -> gui instanceof GUIButtonCloseWindow || gui instanceof GUIButtonMinimizeWindow).filter(AbstractGUI::isVisible).sorted((gui1, gui2) -> gui1.getZLevel() > gui2.getZLevel() ? -1 : (gui1.getZLevel() < gui2.getZLevel() ? 1 : 0)).forEach(gui -> gui.draw(mouseX, mouseY));
        } else {
            super.draw(mouseX, mouseY);
        }
    }

    public void close() {
        if (this.closable) {
            this.parent.removeChild(this);
        }
    }

    public void toggleMinimized() {
        if (this.minimizable) {
            this.minimized = !this.minimized;
        }
    }

    public GUIComponentWindow setTitle(String title) {
        this.title = title;
        return this;
    }

    public GUIComponentWindow setMainColor(Color mainColor) {
        this.mainColor = mainColor;
        return this;
    }

    public GUIComponentWindow setTitleBarColor(Color titleBarColor) {
        this.titleBarColor = titleBarColor;
        return this;
    }

    public GUIComponentWindow setTitleColor(Color titleColor) {
        this.titleColor = titleColor;
        return this;
    }

    @Override
    public void setZLevel(float zLevel) {
        this.zLevel = zLevel;
        for (int i = 0; i < this.children.size(); ++i) {
            ((AbstractGUI)this.children.get(i)).setZLevel(zLevel + (float)i * 0.001f);
        }
    }
}

