/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.mirror;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import net.shadowfacts.mirror.Mirror;
import net.shadowfacts.mirror.MirrorClass;

public class MirrorField {
    private Field field;

    MirrorField(Field field) {
        this.field = field;
    }

    public Field unwrap() {
        return this.field;
    }

    public String name() {
        return this.field.getName();
    }

    public MirrorClass<?> declaringClass() {
        return Mirror.of(this.field.getDeclaringClass());
    }

    public MirrorField setAccessible(boolean accessible) {
        this.field.setAccessible(accessible);
        return this;
    }

    public Object get(Object instance) {
        try {
            return this.field.get(instance);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public void set(Object instance, Object value) {
        try {
            this.field.set(instance, value);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public MirrorClass<?> type() {
        return Mirror.of(this.field.getType());
    }

    public int modifiers() {
        return this.field.getModifiers();
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.modifiers());
    }

    public boolean isNotStatic() {
        return !this.isStatic();
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.modifiers());
    }

    public boolean isNotFinal() {
        return !this.isFinal();
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.modifiers());
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.modifiers());
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.modifiers());
    }

    public boolean hasModifier(int modifier) {
        return (this.modifiers() & modifier) != 0;
    }

    public boolean hasAnnotation(Class<? extends Annotation> clazz) {
        return this.field.isAnnotationPresent(clazz);
    }

    public <A extends Annotation> A getAnnotation(Class<A> clazz) {
        return this.field.getAnnotation(clazz);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MirrorField that = (MirrorField)o;
        return this.field.equals(that.field);
    }

    public int hashCode() {
        return this.field.hashCode();
    }
}

