/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.network;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import sonar.core.SonarCore;
import sonar.core.api.utils.BlockCoords;
import sonar.flux.FluxNetworks;
import sonar.flux.api.ClientFlux;
import sonar.flux.api.network.IFluxNetwork;
import sonar.flux.api.tiles.IFlux;

public class PacketFluxConnectionsList
implements IMessage {
    public ArrayList<ClientFlux> connections;
    public int networkID;

    public PacketFluxConnectionsList() {
    }

    public PacketFluxConnectionsList(ArrayList<ClientFlux> networks, int networkID) {
        this.connections = networks;
        this.networkID = networkID;
    }

    public void fromBytes(ByteBuf buf) {
        this.networkID = buf.readInt();
        this.connections = Lists.newArrayList();
        NBTTagCompound compound = ByteBufUtils.readTag((ByteBuf)buf);
        NBTTagList list = compound.func_150295_c("connects", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound c = list.func_150305_b(i);
            ClientFlux net = new ClientFlux(BlockCoords.readFromNBT((NBTTagCompound)c), IFlux.ConnectionType.values()[c.func_74762_e("type")], c.func_74762_e("priority"), c.func_74763_f("limit"), c.func_74779_i("name"));
            this.connections.add(net);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.networkID);
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (ClientFlux flux : this.connections) {
            NBTTagCompound netTag = new NBTTagCompound();
            BlockCoords.writeToNBT((NBTTagCompound)netTag, (BlockCoords)flux.getCoords());
            netTag.func_74768_a("type", flux.getConnectionType().ordinal());
            netTag.func_74768_a("priority", flux.getCurrentPriority());
            netTag.func_74772_a("limit", flux.getTransferLimit());
            netTag.func_74778_a("name", flux.customName);
            list.func_74742_a((NBTBase)netTag);
        }
        tag.func_74782_a("connects", (NBTBase)list);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    public static class Handler
    implements IMessageHandler<PacketFluxConnectionsList, IMessage> {
        public IMessage onMessage(final PacketFluxConnectionsList message, final MessageContext ctx) {
            if (ctx.side == Side.CLIENT) {
                SonarCore.proxy.getThreadListener(ctx).func_152344_a(new Runnable(){

                    @Override
                    public void run() {
                        String playerName = SonarCore.proxy.getPlayerEntity(ctx).func_70005_c_();
                        IFluxNetwork common = FluxNetworks.getClientCache().getNetwork(message.networkID);
                        if (!common.isFakeNetwork()) {
                            common.setClientConnections(message.connections);
                        }
                    }
                });
            }
            return null;
        }
    }
}

