/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.network;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.sync.DirtyPart;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.ISyncPart;
import sonar.core.network.sync.ISyncableListener;
import sonar.core.network.sync.SyncTagType;
import sonar.core.network.sync.SyncableList;
import sonar.flux.api.network.EnergyStats;
import sonar.flux.api.network.FluxCache;
import sonar.flux.api.network.INetworkStatistics;
import sonar.flux.api.tiles.IFlux;
import sonar.flux.api.tiles.IFluxListenable;

public class NetworkStatistics
extends DirtyPart
implements INetworkStatistics,
ISyncableListener,
ISyncPart {
    public static final int keep = 15;
    public static final int updateEvery = 100;
    public SyncTagType.INT pointCount = new SyncTagType.INT(0);
    public SyncTagType.INT plugCount = new SyncTagType.INT(1);
    public SyncTagType.INT storageCount = new SyncTagType.INT(2);
    public EnergyStats previousRecords = new EnergyStats(0L, 0L, 0L);
    public EnergyStats latestRecords = new EnergyStats(0L, 0L, 0L);
    public int ticks = 0;
    public SyncableList parts = new SyncableList((ISyncableListener)this);

    public NetworkStatistics() {
        this.parts.addParts(new IDirtyPart[]{this.pointCount, this.plugCount, this.storageCount});
    }

    public void inputStatistics(EnergyStats stats, HashMap<FluxCache, ArrayList<IFluxListenable>> connections) {
        this.plugCount.setObject((Object)connections.getOrDefault(FluxCache.plug, Lists.newArrayList()).size());
        this.pointCount.setObject((Object)connections.getOrDefault(FluxCache.point, Lists.newArrayList()).size());
        this.storageCount.setObject((Object)connections.getOrDefault(FluxCache.storage, Lists.newArrayList()).size());
        this.previousRecords = new EnergyStats(this.latestRecords.transfer, this.latestRecords.maxSent, this.latestRecords.maxReceived);
        this.latestRecords = stats;
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        NBTTagCompound tag = nbt.func_74775_l(this.getTagName());
        NBTHelper.readSyncParts((NBTTagCompound)tag, (NBTHelper.SyncType)type, (SyncableList)this.parts);
        this.previousRecords.readData(nbt, type);
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        NBTTagCompound tag = new NBTTagCompound();
        NBTHelper.writeSyncParts((NBTTagCompound)tag, (NBTHelper.SyncType)type, (SyncableList)this.parts, (boolean)false);
        nbt.func_74782_a(this.getTagName(), (NBTBase)tag);
        this.previousRecords.writeData(nbt, type);
        return nbt;
    }

    public void writeToBuf(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.writeData(new NBTTagCompound(), NBTHelper.SyncType.SAVE));
    }

    public void readFromBuf(ByteBuf buf) {
        this.readData(ByteBufUtils.readTag((ByteBuf)buf), NBTHelper.SyncType.SAVE);
    }

    @Override
    public EnergyStats getLatestStats() {
        return this.previousRecords;
    }

    @Override
    public ArrayList<EnergyStats> getRecordedStats() {
        return null;
    }

    @Override
    public int getConnectionCount(IFlux.ConnectionType type) {
        switch (type) {
            case PLUG: {
                return (Integer)this.plugCount.getObject();
            }
            case POINT: {
                return (Integer)this.pointCount.getObject();
            }
            case STORAGE: {
                return (Integer)this.storageCount.getObject();
            }
        }
        return 0;
    }

    public void markChanged(IDirtyPart part) {
        this.parts.markSyncPartChanged(part);
        this.markChanged();
    }

    public boolean canSync(NBTHelper.SyncType sync) {
        return sync.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SAVE, NBTHelper.SyncType.DEFAULT_SYNC});
    }

    public String getTagName() {
        return "nstats";
    }

    @Override
    public EnergyStats getCurrentStats() {
        return this.latestRecords;
    }
}

