/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.network;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.player.EntityPlayer;
import sonar.flux.api.network.IFluxNetwork;
import sonar.flux.api.network.IFluxNetworkCache;
import sonar.flux.connection.EmptyFluxNetwork;

public class ClientNetworkCache
implements IFluxNetworkCache {
    public ConcurrentHashMap<UUID, ArrayList<IFluxNetwork>> networks = new ConcurrentHashMap();

    @Override
    public IFluxNetwork getNetwork(int iD) {
        for (Map.Entry<UUID, ArrayList<IFluxNetwork>> entry : this.networks.entrySet()) {
            for (IFluxNetwork common : entry.getValue()) {
                if (common.isFakeNetwork() || iD != common.getNetworkID()) continue;
                return common;
            }
        }
        return EmptyFluxNetwork.INSTANCE;
    }

    @Override
    public ArrayList<IFluxNetwork> getAllowedNetworks(EntityPlayer player, boolean admin) {
        ArrayList available = Lists.newArrayList();
        for (IFluxNetwork network : this.getAllNetworks()) {
            if (!network.getPlayerAccess(player).canConnect()) continue;
            available.add(network);
        }
        return available;
    }

    @Override
    public ArrayList<IFluxNetwork> getAllNetworks() {
        ArrayList available = Lists.newArrayList();
        for (Map.Entry<UUID, ArrayList<IFluxNetwork>> entry : this.networks.entrySet()) {
            available.addAll((Collection)entry.getValue());
        }
        return available;
    }
}

