/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.connection;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.api.utils.ActionType;
import sonar.core.helpers.FunctionHelper;
import sonar.core.helpers.SonarHelper;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.utils.CustomColour;
import sonar.flux.api.ClientFlux;
import sonar.flux.api.FluxListener;
import sonar.flux.api.network.EnergyStats;
import sonar.flux.api.network.FluxCache;
import sonar.flux.api.network.FluxPlayer;
import sonar.flux.api.network.IFluxCommon;
import sonar.flux.api.network.IFluxNetwork;
import sonar.flux.api.network.PlayerAccess;
import sonar.flux.api.tiles.IFlux;
import sonar.flux.api.tiles.IFluxController;
import sonar.flux.api.tiles.IFluxListenable;
import sonar.flux.api.tiles.IFluxPlug;
import sonar.flux.api.tiles.IFluxPoint;
import sonar.flux.api.tiles.IFluxStorage;
import sonar.flux.connection.FluxHelper;
import sonar.flux.connection.FluxNetworkCommon;
import sonar.flux.network.FluxNetworkCache;
import sonar.flux.network.NetworkStatistics;

public class BasicFluxNetwork
extends FluxNetworkCommon
implements IFluxNetwork {
    public HashMap<FluxCache, ArrayList<IFluxListenable>> connections = Maps.newHashMap();
    public List<FluxCache> changedTypes = Lists.newArrayList(FluxCache.types);
    public Queue<IFluxListenable> toAdd = new ConcurrentLinkedQueue<IFluxListenable>();
    public Queue<IFluxListenable> toRemove = new ConcurrentLinkedQueue<IFluxListenable>();
    public boolean hasConnections;

    public BasicFluxNetwork() {
    }

    public BasicFluxNetwork(int ID, UUID owner, String name, CustomColour colour, IFluxCommon.AccessType type) {
        super(ID, owner, name, colour, type);
    }

    public void addConnections() {
        if (this.toAdd.isEmpty()) {
            return;
        }
        Iterator iterator = this.toAdd.iterator();
        while (iterator.hasNext()) {
            IFluxListenable tile = (IFluxListenable)iterator.next();
            FluxCache.getValidTypes(tile).forEach(type -> {
                if (!this.getConnections((FluxCache)type).contains(tile) && this.getConnections((FluxCache)type).add(tile)) {
                    type.connect(this, tile);
                    this.markTypeDirty((FluxCache)type);
                }
            });
            tile.connect(this);
            iterator.remove();
        }
    }

    public void removeConnections() {
        if (this.toRemove.isEmpty()) {
            return;
        }
        Iterator iterator = this.toRemove.iterator();
        while (iterator.hasNext()) {
            IFluxListenable tile = (IFluxListenable)iterator.next();
            FluxCache.getValidTypes(tile).forEach(type -> {
                if (this.getConnections((FluxCache)type).remove(tile)) {
                    type.disconnect(this, tile);
                    this.markTypeDirty((FluxCache)type);
                }
            });
            iterator.remove();
        }
    }

    @Override
    public void markTypeDirty(FluxCache ... caches) {
        for (FluxCache cache : caches) {
            if (this.changedTypes.contains(cache)) continue;
            this.changedTypes.add(cache);
        }
    }

    public void updateTypes() {
        if (!this.changedTypes.isEmpty()) {
            this.changedTypes.forEach(type -> type.update(this));
            this.changedTypes.clear();
        }
    }

    @Override
    public <T extends IFluxListenable> List<T> getConnections(FluxCache<T> type) {
        return this.connections.computeIfAbsent(type, FunctionHelper.ARRAY);
    }

    public IFluxController.TransferMode getTransferMode() {
        IFluxController controller = this.getController();
        return controller != null ? (controller.getTransferMode().isBanned() ? IFluxController.TransferMode.DEFAULT : controller.getTransferMode()) : IFluxController.TransferMode.DEFAULT;
    }

    @Override
    public void updateNetwork() {
        this.addConnections();
        this.removeConnections();
        this.updateTypes();
        IFluxController.TransferMode mode = this.getTransferMode();
        List buffer = this.getConnections(FluxCache.storage);
        List<IFluxPoint> points = this.getConnections(FluxCache.point);
        List<IFluxPlug> plugs = this.getConnections(FluxCache.plug);
        if ((Integer)this.networkID.getObject() == -1 || points.isEmpty() || plugs.isEmpty()) {
            return;
        }
        EnergyStats stats = new EnergyStats(0L, 0L, 0L);
        plugs.forEach(plug -> stats.maxSent += FluxHelper.pullEnergy(plug, plug.getCurrentTransferLimit(), ActionType.SIMULATE));
        points.forEach(point -> stats.maxReceived += FluxHelper.pushEnergy(point, point.getCurrentTransferLimit(), ActionType.SIMULATE));
        long currentTransfer = stats.transfer;
        if (stats.maxReceived != 0L && stats.maxSent != 0L) {
            IFluxController controller = this.getController();
            for (int current = mode.repeat; current != 0; --current) {
                for (IFluxPlug plug2 : plugs) {
                    stats.transfer += FluxHelper.transferEnergy(plug2, points, mode);
                }
            }
        }
        this.networkStats.inputStatistics(stats, this.connections);
    }

    public void resetStorageValues() {
        List storages = this.getConnections(FluxCache.storage);
        long maxStored = 0L;
        long energyStored = 0L;
        for (IFluxStorage storage : storages) {
            maxStored += storage.getMaxEnergyStored();
            energyStored += storage.getEnergyStored();
        }
        this.maxStored.setObject((Object)maxStored);
        this.energyStored.setObject((Object)energyStored);
    }

    @Override
    public boolean hasController() {
        return this.getController() != null;
    }

    @Override
    public IFluxController getController() {
        List flux = this.getConnections(FluxCache.controller);
        return !flux.isEmpty() ? (IFluxController)flux.get(0) : null;
    }

    @Override
    public void setNetworkName(String name) {
        if (name != null && !name.isEmpty()) {
            this.networkName.setObject((Object)name);
        }
    }

    @Override
    public void setAccessType(IFluxCommon.AccessType type) {
        if (type != null) {
            this.accessType.setObject((Enum)type);
            this.markDirty();
        }
    }

    @Override
    public void setCustomColour(CustomColour colour) {
        this.colour.setObject((INBTSyncable)colour);
    }

    @Override
    public void markDirty() {
        this.connectAll();
        FluxNetworkCache.instance().updateNetworkList();
    }

    @Override
    public void removePlayerAccess(UUID playerUUID, PlayerAccess access) {
        ArrayList toDelete = Lists.newArrayList();
        this.players.stream().filter(p -> p.getUUID().equals(playerUUID)).forEach(p -> toDelete.add(p));
        toDelete.forEach(delete -> this.players.remove((FluxPlayer)delete));
    }

    @Override
    public void addPlayerAccess(UUID playerUUID, PlayerAccess access) {
        for (FluxPlayer player : this.players) {
            if (!player.getUUID().equals(playerUUID)) continue;
            player.setAccess(access);
            return;
        }
        FluxPlayer player = new FluxPlayer(playerUUID, access);
        player.cachedName = SonarHelper.getProfileByUUID((UUID)playerUUID).getName();
        this.players.add(player);
    }

    @Override
    public long receiveEnergy(long maxReceive, ActionType type) {
        return 0L;
    }

    @Override
    public long extractEnergy(long maxExtract, ActionType type) {
        return 0L;
    }

    @Override
    public void addConnection(IFluxListenable tile) {
        this.toAdd.add(tile);
        this.toRemove.remove(tile);
    }

    @Override
    public void removeConnection(IFluxListenable tile) {
        this.toRemove.add(tile);
        this.toAdd.remove(tile);
    }

    @Override
    public void buildFluxConnections() {
        ArrayList clientConnections = Lists.newArrayList();
        List<IFluxListenable> connections = this.getConnections(FluxCache.flux);
        connections.forEach(flux -> clientConnections.add(new ClientFlux((IFlux)flux)));
        this.fluxConnections = clientConnections;
    }

    @Override
    public PlayerAccess getPlayerAccess(EntityPlayer player) {
        UUID playerID = FluxHelper.getOwnerUUID(player);
        if (this.getOwnerUUID().equals(playerID)) {
            return PlayerAccess.OWNER;
        }
        if (this.accessType.getObject() != IFluxCommon.AccessType.PRIVATE) {
            for (FluxPlayer fluxPlayer : this.players) {
                if (!playerID.equals(fluxPlayer.getUUID())) continue;
                return fluxPlayer.getAccess();
            }
            if (this.accessType.getObject() == IFluxCommon.AccessType.PUBLIC) {
                return PlayerAccess.USER;
            }
        }
        return PlayerAccess.BLOCKED;
    }

    @Override
    public IFluxNetwork updateNetworkFrom(IFluxNetwork network) {
        this.setAccessType(network.getAccessType());
        this.setCustomColour(network.getNetworkColour());
        this.setNetworkName(network.getNetworkName());
        this.players = network.getPlayers();
        this.energyStored.setObject((Object)network.getEnergyAvailable());
        this.maxStored.setObject((Object)network.getMaxEnergyStored());
        this.networkStats = (NetworkStatistics)network.getStatistics();
        return this;
    }

    public void markChanged(IDirtyPart part) {
        this.parts.markSyncPartChanged(part);
    }

    public void connectAll() {
        this.forEachConnection(FluxCache.flux, flux -> flux.connect(this));
    }

    public void disconnectAll() {
        this.forEachConnection(FluxCache.flux, flux -> flux.disconnect(this));
    }

    public void forEachConnection(FluxCache type, Consumer<? super IFluxListenable> action) {
        this.getConnections(type).forEach(action);
    }

    public void forEachViewer(FluxListener listener, Consumer<EntityPlayerMP> action) {
        this.forEachConnection(FluxCache.flux, f -> f.getListenerList().getListeners(new Enum[]{listener}).forEach(p -> action.accept(p.player)));
    }

    @Override
    public void onRemoved() {
        this.disconnectAll();
        this.connections.clear();
        this.toAdd.clear();
        this.toRemove.clear();
    }

    public void updateFluxTallies() {
        this.networkStats.plugCount.setObject((Object)this.getConnections(FluxCache.plug).size());
        this.networkStats.pointCount.setObject((Object)this.getConnections(FluxCache.point).size());
        this.networkStats.storageCount.setObject((Object)this.getConnections(FluxCache.storage).size());
    }

    @Override
    public void setHasConnections(boolean bool) {
        this.hasConnections = bool;
    }
}

