/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.common.tileentity;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import sonar.core.SonarCore;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncEnergyStorage;
import sonar.core.utils.IGuiTile;
import sonar.flux.FluxConfig;
import sonar.flux.api.network.FluxCache;
import sonar.flux.api.tiles.IFlux;
import sonar.flux.api.tiles.IFluxStorage;
import sonar.flux.client.GuiFlux;
import sonar.flux.common.ContainerFlux;
import sonar.flux.common.tileentity.TileEntityFlux;

public class TileEntityStorage
extends TileEntityFlux
implements IGuiTile,
IFluxStorage {
    public final SyncEnergyStorage storage;
    public int maxTransfer;

    public TileEntityStorage(int capacity, int transfer) {
        super(IFlux.ConnectionType.STORAGE);
        this.maxTransfer = transfer;
        this.storage = new SyncEnergyStorage(capacity, this.maxTransfer);
        this.syncList.addPart((IDirtyPart)this.storage);
    }

    public void markChanged(IDirtyPart part) {
        super.markChanged(part);
        if (this.func_145831_w() != null && this.isServer()) {
            if (part == this.storage) {
                this.network.markTypeDirty(FluxCache.storage);
                SonarCore.sendPacketAround((TileEntity)this, (int)128, (int)10);
            } else if (part == this.colour) {
                SonarCore.sendPacketAround((TileEntity)this, (int)128, (int)11);
            }
        }
    }

    @Override
    public boolean canTransfer() {
        return true;
    }

    public Object getGuiContainer(EntityPlayer player) {
        return new ContainerFlux(player, this, false);
    }

    public Object getGuiScreen(EntityPlayer player) {
        return new GuiFlux((Container)this.getGuiContainer(player), this, player);
    }

    @Override
    public long getTransferLimit() {
        return this.storage.getMaxExtract();
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.storage.getMaxEnergyStored();
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.DROP})) {
            this.storage.setEnergyStored(nbt.func_74762_e("energy"));
        }
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.DROP})) {
            nbt.func_74768_a("energy", this.storage.getEnergyStored());
        }
        return nbt;
    }

    @Override
    public void writePacket(ByteBuf buf, int id) {
        super.writePacket(buf, id);
        switch (id) {
            case 10: {
                this.storage.writeToBuf(buf);
                break;
            }
            case 11: {
                this.colour.writeToBuf(buf);
            }
        }
    }

    @Override
    public void readPacket(ByteBuf buf, int id) {
        super.readPacket(buf, id);
        switch (id) {
            case 10: {
                this.storage.readFromBuf(buf);
                break;
            }
            case 11: {
                this.colour.readFromBuf(buf);
            }
        }
    }

    @Override
    public long getMaxEnergyStored() {
        return this.storage.getFullCapacity();
    }

    @Override
    public long getEnergyStored() {
        return this.storage.getEnergyLevel();
    }

    public static class Massive
    extends TileEntityStorage {
        public Massive() {
            super(FluxConfig.gargantuanCapacity, FluxConfig.gargantuanTransfer);
            this.customName.setDefault((Object)"Gargantuan Storage");
        }
    }

    public static class Advanced
    extends TileEntityStorage {
        public Advanced() {
            super(FluxConfig.herculeanCapacity, FluxConfig.herculeanTransfer);
            this.customName.setDefault((Object)"Herculean Storage");
        }
    }

    public static class Basic
    extends TileEntityStorage {
        public Basic() {
            super(FluxConfig.basicCapacity, FluxConfig.basicTransfer);
            this.customName.setDefault((Object)"Basic Storage");
        }
    }
}

