/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.common.block;

import cofh.api.energy.IEnergyConnection;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import sonar.core.api.SonarAPI;
import sonar.core.api.utils.BlockInteraction;
import sonar.core.common.block.SonarMachineBlock;
import sonar.core.common.block.SonarMaterials;
import sonar.flux.api.tiles.IFlux;
import sonar.flux.common.tileentity.TileEntityCable;

public class FluxCable
extends SonarMachineBlock {
    private AxisAlignedBB bounds = field_185505_j;
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    public static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");
    public static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");

    public FluxCable() {
        super(SonarMaterials.machine, false, true);
        this.setBlockBounds(0.25, 0.25, 0.25, 0.75, 0.75, 0.75);
    }

    public TileEntity func_149915_a(World world, int i) {
        return new TileEntityCable();
    }

    public boolean operateBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, BlockInteraction interact) {
        if (!world.field_72995_K) {
            // empty if block
        }
        return false;
    }

    public boolean hasSpecialRenderer() {
        return true;
    }

    public boolean checkBlockInDirection(IBlockAccess world, BlockPos pos, EnumFacing dir) {
        TileEntity tile = world.func_175625_s(pos.func_177972_a(dir));
        if (tile != null) {
            if (tile instanceof IFlux || tile instanceof TileEntityCable || tile instanceof IEnergyConnection) {
                return true;
            }
            if (SonarAPI.getEnergyHelper().canTransferEnergy(tile, dir) != null) {
                return true;
            }
        }
        return false;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess w, BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        return state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.checkBlockInDirection(w, pos, EnumFacing.NORTH))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.checkBlockInDirection(w, pos, EnumFacing.SOUTH))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.checkBlockInDirection(w, pos, EnumFacing.WEST))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.checkBlockInDirection(w, pos, EnumFacing.EAST))).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(this.checkBlockInDirection(w, pos, EnumFacing.UP))).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(this.checkBlockInDirection(w, pos, EnumFacing.DOWN)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{NORTH, EAST, SOUTH, WEST, DOWN, UP});
    }

    public boolean dropStandard(IBlockAccess world, BlockPos pos) {
        return true;
    }
}

