/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.client.states;

import com.google.common.collect.Lists;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import sonar.core.client.gui.SonarTextField;
import sonar.core.client.gui.widgets.SonarScroller;
import sonar.core.helpers.FontHelper;
import sonar.flux.FluxNetworks;
import sonar.flux.api.network.FluxPlayer;
import sonar.flux.api.network.FluxPlayersList;
import sonar.flux.api.network.IFluxCommon;
import sonar.flux.api.network.PlayerAccess;
import sonar.flux.client.GuiFlux;
import sonar.flux.client.GuiState;
import sonar.flux.client.GuiTypeMessage;
import sonar.flux.network.PacketFluxButton;

public class GuiStateNetworkPlayers
extends GuiState {
    public SonarScroller scroller;
    public SonarTextField playerName;
    public PlayerAccess playerAccess = PlayerAccess.USER;
    public FluxPlayer selectedPlayer = null;
    public static int listSize = 10;

    public GuiStateNetworkPlayers() {
        super(GuiTypeMessage.PLAYERS, 176, 166, 386, "network.players");
    }

    @Override
    public void init(GuiFlux flux) {
        this.scroller = new SonarScroller(flux.getGuiLeft() + 165, flux.getGuiTop() + 8, 146, 10);
        this.selectedPlayer = null;
        int networkColour = flux.common.getNetworkColour().getRGB();
        flux.getButtonList().add((GuiButton)flux.selectButton(1, flux.getGuiLeft() + 150, flux.getGuiTop() + 138, 136, "Add"));
        this.playerName = new SonarTextField(1, flux.getFontRenderer(), 14, 138, 130, 12).setBoxOutlineColour(networkColour);
        this.playerName.func_146203_f(24);
        this.playerName.func_146180_a("");
        if (!flux.common.isFakeNetwork() && flux.common.getAccessType() == IFluxCommon.AccessType.PRIVATE) {
            flux.disabledState = true;
        }
    }

    @Override
    public void draw(GuiFlux flux, int x, int y) {
        if (flux.common.isFakeNetwork()) {
            flux.renderNavigationPrompt("No players can be added", "Network Selection");
            return;
        }
        if (flux.disabledState) {
            flux.renderNavigationPrompt("Unavailable in Private Mode", "Edit Network");
            return;
        }
        FluxPlayersList players = flux.common.getPlayers();
        FluxPlayer currentPlayer = null;
        if (!players.isEmpty()) {
            int start = (int)((float)players.size() * this.scroller.getCurrentScroll());
            int finish = Math.min(start + listSize, players.size());
            for (int i = start; i < finish; ++i) {
                FluxPlayer player = (FluxPlayer)players.get(i);
                if (players.get(i) == null) continue;
                int xPos = 11;
                int yPos = 8 + 12 * i - 12 * start;
                PlayerAccess access = player.getAccess();
                boolean isOwner = flux.common.getCachedPlayerName().equals(player.getCachedName());
                GuiFlux.func_73734_a((int)xPos, (int)yPos, (int)(xPos + 154), (int)(yPos + 12), (int)(access.canDelete() || isOwner ? Color.lightGray.getRGB() : (access.canEdit() ? GuiFlux.colours[7].getRGB() : (!access.canConnect() ? GuiFlux.colours[4].getRGB() : GuiFlux.lightBlue))));
                flux.bindTexture(flux.getBackground());
                flux.func_73729_b(xPos, yPos, 0, 166, 154, 12);
                FontHelper.text((String)player.getCachedName(), (int)(xPos + 3), (int)(yPos + 2), (int)Color.white.getRGB());
                flux.bindTexture(GuiFlux.buttons);
                flux.func_73729_b(xPos + 154 - 12, yPos, 56, 0, 11, 11);
                if (x <= flux.getGuiLeft() + xPos || x >= flux.getGuiLeft() + xPos + 154 || y < flux.getGuiTop() + yPos || y >= flux.getGuiTop() + yPos + 12) continue;
                currentPlayer = (FluxPlayer)players.get(i);
            }
        }
        this.selectedPlayer = currentPlayer;
        if (this.selectedPlayer != null) {
            boolean isOwner = flux.common.getCachedPlayerName().equals(this.selectedPlayer.getCachedName());
            ArrayList strings = Lists.newArrayList();
            if (x > flux.getGuiLeft() + 11 + 142 && x < flux.getGuiLeft() + 11 + 153) {
                strings.add(TextFormatting.RED + "Delete: " + this.selectedPlayer.getCachedName());
            } else {
                strings.add(TextFormatting.AQUA + "Config: " + FontHelper.translate((String)(isOwner ? PlayerAccess.OWNER.getName() : this.selectedPlayer.access.getName())));
                strings.add("Right click to change");
            }
            flux.func_146283_a(strings, x - flux.getGuiLeft(), y - flux.getGuiTop());
        }
        flux.bindTexture(flux.getBackground());
    }

    @Override
    public void button(GuiFlux flux, GuiButton button) {
        switch (button.field_146127_k) {
            case 1: {
                if (this.playerName.func_146179_b().isEmpty()) break;
                FluxNetworks.network.sendToServer((IMessage)new PacketFluxButton(PacketFluxButton.Type.ADD_PLAYER, flux.tile.func_174877_v(), new Object[]{flux.getNetworkID(), this.playerName.func_146179_b(), PlayerAccess.USER}));
                return;
            }
        }
    }

    @Override
    public void click(GuiFlux flux, int x, int y, int mouseButton) {
        if (this.selectedPlayer != null) {
            if (x - flux.getGuiLeft() > 153 && x - flux.getGuiLeft() < 164) {
                FluxNetworks.network.sendToServer((IMessage)new PacketFluxButton(PacketFluxButton.Type.REMOVE_PLAYER, flux.tile.func_174877_v(), new Object[]{flux.getNetworkID(), this.selectedPlayer.id, this.selectedPlayer.access}));
            } else if (mouseButton == 1) {
                FluxNetworks.network.sendToServer((IMessage)new PacketFluxButton(PacketFluxButton.Type.CHANGE_PLAYER, flux.tile.func_174877_v(), new Object[]{flux.getNetworkID(), this.selectedPlayer.id, this.selectedPlayer.access.incrementAccess()}));
            }
        }
    }

    @Override
    public SonarTextField[] getFields(GuiFlux flux) {
        return new SonarTextField[]{this.playerName};
    }

    @Override
    public SonarScroller[] getScrollers() {
        return new SonarScroller[]{this.scroller};
    }

    @Override
    public int getSelectionSize(GuiFlux flux) {
        return flux.common.getPlayers().size();
    }
}

