/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.client;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.opengl.GL11;
import sonar.core.helpers.FontHelper;
import sonar.flux.FluxNetworks;
import sonar.flux.api.configurator.FluxConfigurationType;
import sonar.flux.client.GuiFluxBase;
import sonar.flux.common.ContainerConfigurator;
import sonar.flux.network.PacketConfiguratorSettings;

public class GuiConfigurator
extends GuiContainer {
    public HashMap<FluxConfigurationType, Boolean> configs = Maps.newHashMap();

    public GuiConfigurator(EntityPlayer player, ItemStack configurator) {
        super((Container)new ContainerConfigurator(player));
        NBTTagCompound tag = configurator.func_179543_a("disabled", true);
        for (FluxConfigurationType type : FluxConfigurationType.values()) {
            boolean disabled = tag.func_74767_n(type.getNBTName());
            this.configs.put(type, disabled);
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        for (Map.Entry<FluxConfigurationType, Boolean> entry : this.configs.entrySet()) {
            int ordinal = entry.getKey().ordinal();
            this.field_146292_n.add(new GuiButton(ordinal, this.field_147003_i + 100, this.field_147009_r + 20 + ordinal * 24, 60, 20, entry.getValue() != false ? TextFormatting.RED + "DISABLED" : TextFormatting.GREEN + "ENABLED"));
        }
    }

    protected void func_146284_a(GuiButton button) {
        FluxConfigurationType type;
        this.configs.put(type, this.configs.get((Object)(type = FluxConfigurationType.values()[button.field_146127_k])) == false);
        this.field_146292_n.clear();
        this.func_73866_w_();
    }

    public void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        FontHelper.textCentre((String)(TextFormatting.UNDERLINE + "Flux Configurator"), (int)this.field_146999_f, (int)8, (int)-1);
        for (Map.Entry<FluxConfigurationType, Boolean> entry : this.configs.entrySet()) {
            FontHelper.text((String)entry.getKey().name(), (int)8, (int)(26 + entry.getKey().ordinal() * 24), (int)-1);
        }
    }

    public NBTTagCompound getNewDisabledTag() {
        NBTTagCompound disabled = new NBTTagCompound();
        for (Map.Entry<FluxConfigurationType, Boolean> entry : this.configs.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            disabled.func_74757_a(entry.getKey().getNBTName(), true);
        }
        return disabled;
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiFluxBase.bground);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1 || this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(keyCode)) {
            FluxNetworks.network.sendToServer((IMessage)new PacketConfiguratorSettings(this.getNewDisabledTag()));
        }
        super.func_73869_a(typedChar, keyCode);
    }
}

